/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import java.util.Hashtable;
import java.util.Iterator;
import weblogic.auddi.util.ConnectException;
import weblogic.auddi.util.Connection;
import weblogic.auddi.util.Initializable;
import weblogic.auddi.util.InitializationException;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.ShutdownException;
import weblogic.auddi.util.ShutdownManager;
import weblogic.auddi.util.Shutdownable;

public abstract class ConnectionPool
implements Shutdownable,
Initializable {
    private String m_poolName;
    private Hashtable m_pool;
    private Hashtable m_busyPool;
    private int m_systemPoolSize = 0;
    private int m_connectionCounter = -1;
    private boolean m_isInitialized = false;

    public abstract int getPoolIncrement();

    public abstract int getPoolInitialSize();

    public abstract int getPoolMaxSize();

    public abstract int getPoolSystemMaxSize();

    public void initialize() throws InitializationException {
        Logger.trace("+ConnectionPool.initialize()");
        try {
            this.m_pool = new Hashtable();
            this.m_busyPool = new Hashtable();
            this.uninitialize();
            this.m_connectionCounter = 0;
            this.createConnections(this.getPoolInitialSize());
            this.m_isInitialized = true;
        }
        catch (ConnectException connectException) {
            Logger.error(connectException);
            Logger.trace("-EXCEPTION(InitializationException) ConnectionPool.initialize()");
            throw new InitializationException(connectException);
        }
        catch (ShutdownException shutdownException) {
            Logger.error(shutdownException);
            Logger.trace("-EXCEPTION(InitializationException) ConnectionPool.initialize()");
            throw new InitializationException(shutdownException);
        }
        Logger.trace("-ConnectionPool.initialize()");
    }

    private void uninitialize() throws ShutdownException {
        Logger.trace("+ConnectionPool.uninitialize()");
        this.shutdown();
        Logger.trace("-ConnectionPool.uninitialize()");
    }

    public ConnectionPool(String string) throws ConnectException {
        Logger.trace("+ConnectionPool.CTOR()");
        this.m_poolName = string;
        ShutdownManager.registerApp(this);
        Logger.trace("-ConnectionPool.CTOR()");
    }

    public String getName() {
        return this.m_poolName;
    }

    protected boolean createConnections(int n) throws ConnectException {
        return this.createConnections(n, this.m_pool, this.getPoolMaxSize());
    }

    protected boolean createConnections(int n, Hashtable hashtable, int n2) throws ConnectException {
        Logger.trace("+ConnectionPool.createConnections(), >> " + this.m_poolName);
        if (n2 - hashtable.size() - this.m_busyPool.size() <= 0) {
            Logger.trace("-ConnectionPool.createConnections()");
            return false;
        }
        if (n > n2 - hashtable.size() - this.m_busyPool.size()) {
            n = n2 - hashtable.size() - this.m_busyPool.size();
        }
        for (int i = 0; i < n; ++i) {
            Connection connection = this.getNewConnection();
            hashtable.put(connection.getConnectionObject(), connection);
        }
        Logger.trace("-ConnectionPool.createConnections()");
        return true;
    }

    public abstract Connection getNewConnection() throws ConnectException;

    private int getTotal() {
        return this.m_pool.size() + this.m_busyPool.size();
    }

    public synchronized Connection getConnectionFromPool() throws ConnectException {
        if (!this.m_isInitialized) {
            try {
                this.initialize();
            }
            catch (InitializationException initializationException) {
                Logger.error(initializationException);
                Logger.trace("-EXCEPTION(ConnectException) ConnectionPool.initialize()");
                throw new ConnectException(initializationException);
            }
        }
        ++this.m_connectionCounter;
        boolean bl = false;
        if (this.m_pool.size() == 0 && !(bl = this.createConnections(this.getPoolIncrement()))) {
            if (this.m_busyPool.size() < this.getPoolSystemMaxSize()) {
                Connection connection = this.getNewConnection();
                ++this.m_systemPoolSize;
                return connection;
            }
            Logger.error("NO MORE CONNECTIONS LEFT...");
            return null;
        }
        if (this.m_pool.size() > 0) {
            Object k = this.m_pool.keySet().iterator().next();
            Connection connection = (Connection)this.m_pool.remove(k);
            this.m_busyPool.put(connection.getConnectionObject(), connection);
            return connection;
        }
        return null;
    }

    public synchronized void returnConnectionToPool(Connection connection) throws ConnectException {
        if (this.m_systemPoolSize > 0) {
            --this.m_systemPoolSize;
            connection.close();
        } else {
            Object object = connection.getConnectionObject();
            this.m_busyPool.remove(object);
            this.m_pool.put(object, connection);
        }
    }

    public int getBusySize() {
        return this.m_busyPool.size();
    }

    public int getSystemPoolSize() {
        return this.m_systemPoolSize;
    }

    public int getFreeSize() {
        return this.m_pool.size();
    }

    public int getCounter() {
        return this.m_connectionCounter;
    }

    public void resetCounter() {
        this.m_connectionCounter = 0;
    }

    public void shutdown() throws ShutdownException {
        Logger.trace("+ConnectionPool.shutdown()");
        try {
            Connection connection;
            Iterator iterator = this.m_pool.entrySet().iterator();
            while (iterator.hasNext()) {
                connection = (Connection)iterator.next().getValue();
                connection.close();
            }
            iterator = this.m_busyPool.entrySet().iterator();
            while (iterator.hasNext()) {
                connection = (Connection)iterator.next().getValue();
                connection.close();
            }
            this.m_pool = new Hashtable();
            this.m_busyPool = new Hashtable();
        }
        catch (ConnectException connectException) {
            Logger.trace("-EXCEPTION(ConnectException): ConnectionPool.shutdown()");
            throw new ShutdownException(connectException);
        }
        Logger.trace("-ConnectionPool.shutdown()");
    }

    public void printStats(int n) {
        Logger.Log(n, "m_connectionCounter : " + this.m_connectionCounter);
        Logger.Log(n, "           busySize : " + this.getBusySize());
        Logger.Log(n, "           freeSize : " + this.getFreeSize());
        Logger.Log(n, "     systemPoolSize : " + this.getSystemPoolSize());
    }
}

