/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import weblogic.auddi.util.Logger;
import weblogic.auddi.util.TimerListener;

public class IntervalTimer
extends Thread {
    private long interval;
    private TimerListener timerListener;
    private boolean active;

    public IntervalTimer(TimerListener timerListener, long l) {
        Logger.debug("Thread created that will call back " + timerListener + " every " + l / 1000L + " seconds");
        this.timerListener = timerListener;
        this.interval = l;
        this.active = true;
        this.setDaemon(true);
    }

    public void run() {
        while (this.active) {
            this.timerListener.onTimer();
            try {
                IntervalTimer.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                Logger.debug("Interruped exception in IntervalTimer thread " + this);
            }
        }
    }

    public void stopThread() {
        this.active = false;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public String toString() {
        return "IntervalTimer { alive = " + this.isAlive() + ", " + "interval = " + this.interval + " }";
    }
}

