/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import weblogic.auddi.util.LoggerException;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.util.Util;

public class Logger {
    public static final String LOGGER_ENV_PREFIX = "logger.";
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int TRACE = 4;
    public static final int OUTPUT_SHORT = 20;
    public static final int OUTPUT_LONG = 21;
    public static final int LOG_TYPE_FILE = 14;
    public static final int LOG_TYPE_SCREEN = 15;
    public static final int LOG_TYPE_SCREEN_FILE = 16;
    private int m_logType = -1;
    private int m_outputType = -1;
    private String m_logFileName = null;
    private PrintStream m_userOutput = null;
    private PrintWriter m_logOutput = null;
    private DateFormat m_userDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat m_fileDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar m_currentFileCalendar = Calendar.getInstance();
    private int m_nTraceLevel = 4;
    private String m_outputDir = null;
    private static Logger s_instance = null;
    private static ResourceBundle m_rb;
    private boolean m_indentingEnabled = false;
    private String m_indentStr = "  ";
    private int m_currentIndent = 0;
    private String m_currentIndentStr = "";
    private boolean m_addPrefix = true;
    private boolean m_addPrefixBar = true;
    private boolean m_isQuiet = false;
    private boolean m_loggingEnabled = true;
    private File m_logFile = null;
    private long m_maxLogSize = 5000000L;
    String m_currentLogFileName = null;

    public void resetIndent() {
        this.m_currentIndent = 0;
        this.m_currentIndentStr = "";
    }

    private Logger() {
        this.reloadParams();
        if (!this.m_isQuiet) {
            System.err.println("Logger Started");
        }
    }

    public void setAddPrefixBar(boolean bl) {
        this.m_addPrefixBar = bl;
    }

    public boolean getAddPrefixBar() {
        return this.m_addPrefixBar;
    }

    public void setAddPrefix(boolean bl) {
        this.m_addPrefix = bl;
    }

    public boolean getAddPrefix() {
        return this.m_addPrefix;
    }

    public void setQuiet(boolean bl) {
        this.m_isQuiet = bl;
        PropertyManager.setRuntimeProperty("logger.quiet", String.valueOf(bl));
    }

    public boolean isQuiet() {
        return this.m_isQuiet;
    }

    public static void info(String string) {
        Logger.Log(2, string);
    }

    public static void debug(String string) {
        Logger.Log(3, string);
    }

    public static void error(String string) {
        Logger.Log(0, string);
    }

    public static void warning(String string) {
        Logger.Log(1, string);
    }

    public static void trace(String string) {
        Logger.Log(4, string);
    }

    public static void info(Throwable throwable) {
        Logger.Log(2, throwable);
    }

    public static void debug(Throwable throwable) {
        Logger.Log(3, throwable);
    }

    public static void warning(Throwable throwable) {
        Logger.Log(1, throwable);
    }

    public static void error(Throwable throwable) {
        Logger.Log(0, throwable);
    }

    public static void trace(Throwable throwable) {
        Logger.Log(4, throwable);
    }

    public void setIndentingEnabled(boolean bl) {
        this.m_indentingEnabled = bl;
        if (s_instance != null) {
            PropertyManager.setRuntimeProperty("logger.indent.enabled", String.valueOf(this.m_indentingEnabled));
        }
    }

    public void setIndentingEnabled(Boolean bl) {
        this.setIndentingEnabled((boolean)bl);
    }

    public boolean isEnabled() {
        return this.m_loggingEnabled;
    }

    public void setEnabled(boolean bl) {
        this.m_loggingEnabled = bl;
    }

    public boolean isIndentingEnabled() {
        return this.m_indentingEnabled;
    }

    public void setIndentSize(Integer n) {
        this.m_indentStr = "";
        for (int i = 0; i < n; ++i) {
            this.m_indentStr = this.m_indentStr + " ";
        }
        if (s_instance != null) {
            PropertyManager.setRuntimeProperty("logger.indent.size", n.toString());
        }
    }

    public int getIndentSize() {
        return this.m_indentStr.length();
    }

    private static String getParam(String string) {
        String string2 = PropertyManager.getRuntimeProperty(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            try {
                string2 = m_rb.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public void reloadParams() {
        m_rb = Util.getResource(this);
        String string = PropertyManager.getRuntimeProperty("logger.quiet");
        if (string == null) {
            string = System.getProperty("logger.quiet");
        }
        this.m_isQuiet = string == null || !string.equals("false");
        this.m_nTraceLevel = this.getValueFromString(Logger.getParam("logger.verbosity"));
        this.m_outputDir = Logger.getParam("logger.log.dir");
        if (this.m_outputDir == null) {
            this.m_outputDir = Logger.getParam("logger.log.dir." + Util.getOSName());
            if (this.m_outputDir == null) {
                this.m_outputDir = ".";
            }
        }
        this.m_logType = this.getValueFromString(Logger.getParam("logger.log.type"));
        this.m_outputType = this.getValueFromString(Logger.getParam("logger.output.style"));
        this.m_logFileName = Logger.getParam("logger.log.file.stem");
        this.setIndentSize(Integer.valueOf(Logger.getParam("logger.indent.size")));
        this.setIndentingEnabled((boolean)new Boolean(Logger.getParam("logger.indent.enabled")));
        this.m_maxLogSize = Long.parseLong(Logger.getParam("logger.file.maxsize"));
    }

    public void outputParams(int n) {
        this.log(n, "New Logger parameters : ");
        this.log(n, "       Logger Level : " + this.getTraceLevelAsString(this.m_nTraceLevel));
        this.log(n, "        Output Dir : " + this.m_outputDir);
        this.log(n, "          Log Type : " + this.getLogTypeAsString(this.m_logType));
        this.log(n, "       Output Type : " + this.getOutputTypeAsString(this.m_outputType));
        this.log(n, "   Log File Prefix : " + this.m_logFileName);
        this.log(n, " Log File Max Size : " + this.m_maxLogSize);
        this.log(n, "       Indent Size : " + this.m_indentStr.length());
        this.log(n, "    Indent Enabled : " + this.m_indentingEnabled);
    }

    public void setLogOutputDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new LoggerException("Logger output directory '" + string + "' does not exist.");
        }
        this.m_outputDir = string;
        PropertyManager.setRuntimeProperty("logger.log.dir", this.m_outputDir);
    }

    public void setLogFileStem(String string) {
        this.m_logFileName = string;
        PropertyManager.setRuntimeProperty("logger.log.file.stem", this.m_logFileName);
    }

    public String getLogFileStem() {
        return this.m_logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger instance() {
        if (s_instance != null) return s_instance;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (s_instance != null) return s_instance;
            s_instance = new Logger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public void setLogType(Integer n) {
        this.setLogType((int)n);
    }

    public int getLogType() {
        return this.m_logType;
    }

    public void setLogType(String string) {
        int n = this.getValueFromString(string);
        this.setLogType(n);
    }

    public void setLogType(int n) {
        if (!this.m_isQuiet) {
            this.getStream().println("# Logger log type set from '" + this.getLogTypeAsString(this.m_logType) + "' to '" + this.getLogTypeAsString(n) + "'");
        }
        if (n == 15 && this.m_logOutput != null) {
            this.m_logOutput.close();
            this.m_logOutput = null;
        }
        this.m_logType = n;
        PropertyManager.setRuntimeProperty("logger.log.type", this.getLogTypeAsString(this.m_logType));
    }

    public String getOutputDir() {
        return this.m_outputDir;
    }

    private void initLog() {
        this.initLog(null);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_userOutput != null && this.m_userOutput != System.err) {
            this.m_userOutput.close();
        }
        if (this.m_logOutput != null) {
            this.m_logOutput.close();
        }
    }

    public final PrintStream getStream() {
        if (this.m_userOutput == null) {
            this.m_userOutput = System.err;
        }
        return this.m_userOutput;
    }

    public final void setStream(PrintStream printStream) {
        this.m_userOutput = printStream;
    }

    public void setTraceLevel(String string) {
        int n = this.getValueFromString(string);
        this.setTraceLevel(n);
    }

    public void setTraceLevel(int n) {
        if (!this.m_isQuiet) {
            this.getStream().println("# Logger level set from '" + this.getTraceLevelAsString(this.m_nTraceLevel) + "' to '" + this.getTraceLevelAsString(n) + "'");
        }
        this.m_nTraceLevel = n;
        PropertyManager.setRuntimeProperty("logger.verbosity", this.getTraceLevelAsString(n));
    }

    public void setTraceLevel(Integer n) {
        this.setTraceLevel((int)n);
    }

    public final synchronized void log(int n, String string) {
        if (string == null) {
            return;
        }
        if (n <= this.m_nTraceLevel) {
            StringBuffer stringBuffer = new StringBuffer();
            this.addPrefix(stringBuffer, string);
            stringBuffer.append(string).append("\n");
            this.writeToStream(stringBuffer.toString());
        }
    }

    private void addPrefix(StringBuffer stringBuffer, String string) {
        if (this.m_outputType == 21) {
            stringBuffer.append(this.m_userDateFormat.format(new Date()));
            stringBuffer.append(" | ").append(Thread.currentThread().toString()).append(" | ");
        } else if (this.m_addPrefix) {
            stringBuffer.append(" | ");
        }
        if (this.m_indentingEnabled) {
            if (string != null && string.startsWith("-")) {
                --this.m_currentIndent;
                if (!this.m_currentIndentStr.equals("")) {
                    this.m_currentIndentStr = this.m_currentIndentStr.substring(0, this.m_currentIndentStr.length() - this.m_indentStr.length());
                }
            }
            stringBuffer.append(this.m_currentIndentStr);
            if (string != null && string.startsWith("+")) {
                this.m_currentIndentStr = this.m_currentIndentStr + this.m_indentStr;
                ++this.m_currentIndent;
            }
        }
    }

    public final synchronized void log(int n, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (n <= this.m_nTraceLevel) {
            StringBuffer stringBuffer = new StringBuffer();
            this.addPrefix(stringBuffer, null);
            this.writeToStream(stringBuffer.toString());
            this.writeToStream(throwable);
        }
    }

    public static void Log(int n, String string) {
        Logger.instance().log(n, string);
    }

    public static void Log(int n, Throwable throwable) {
        Logger.instance().log(n, throwable);
    }

    public final boolean canLog(int n) {
        return n <= this.m_nTraceLevel;
    }

    public static final boolean CanLog(int n) {
        return Logger.instance().canLog(n);
    }

    public int getTraceLevel() {
        return this.m_nTraceLevel;
    }

    public String getTraceLevelAsString(int n) {
        switch (n) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "WARNING";
            }
            case 4: {
                return "TRACE";
            }
            case 3: {
                return "DEBUG";
            }
            case 2: {
                return "INFO";
            }
        }
        throw new LoggerException("invalid Logger verbosity : " + n);
    }

    public String getLogTypeAsString(int n) {
        switch (n) {
            case 15: {
                return "LOG_TYPE_SCREEN";
            }
            case 14: {
                return "LOG_TYPE_FILE";
            }
            case 16: {
                return "LOG_TYPE_SCREEN_FILE";
            }
        }
        throw new LoggerException("invalid Logger log type : " + n);
    }

    public String getOutputTypeAsString(int n) {
        switch (n) {
            case 20: {
                return "OUTPUT_SHORT";
            }
            case 21: {
                return "OUTPUT_LONG";
            }
        }
        throw new LoggerException("invalid Logger output type : " + n);
    }

    public int getOutputType() {
        return this.m_outputType;
    }

    public void setOutputType(String string) {
        int n = this.getValueFromString(string);
        this.setOutputType(n);
    }

    public void setOutputType(int n) {
        if (!this.m_isQuiet) {
            this.getStream().println("# Logger Output Type set from '" + this.getOutputTypeAsString(this.m_outputType) + "' to '" + this.getOutputTypeAsString(n) + "'");
        }
        this.m_outputType = n;
        PropertyManager.setRuntimeProperty("logger.output.style", this.getOutputTypeAsString(this.m_outputType));
    }

    public void setMaxSize(long l) {
        if (!this.m_isQuiet) {
            this.getStream().println("# Logger Maximum file size set from '" + this.m_maxLogSize + "' to '" + l + "'");
        }
        this.m_maxLogSize = l;
        PropertyManager.setRuntimeProperty("logger.file.maxsize", String.valueOf(this.m_maxLogSize));
    }

    private int getValueFromString(String string) {
        if (string.equals("TRACE")) {
            return 4;
        }
        if (string.equals("ERROR")) {
            return 0;
        }
        if (string.equals("INFO")) {
            return 2;
        }
        if (string.equals("DEBUG")) {
            return 3;
        }
        if (string.equals("WARNING")) {
            return 1;
        }
        if (string.equals("OUTPUT_SHORT")) {
            return 20;
        }
        if (string.equals("OUTPUT_LONG")) {
            return 21;
        }
        if (string.equals("LOG_TYPE_FILE")) {
            return 14;
        }
        if (string.equals("LOG_TYPE_SCREEN")) {
            return 15;
        }
        if (string.equals("LOG_TYPE_SCREEN_FILE")) {
            return 16;
        }
        throw new LoggerException("The value '" + string + "' during Logger initialization was invalid.  Check your Logger property file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartLog() {
        if (this.m_logOutput != null) {
            PrintWriter printWriter = this.m_logOutput;
            synchronized (printWriter) {
                String string = "rotating the log file...";
                try {
                    switch (this.m_logType) {
                        case 15: {
                            this.m_userOutput.write(string.getBytes());
                            break;
                        }
                        case 14: {
                            this.logToFile(string, false);
                            break;
                        }
                        case 16: {
                            this.m_userOutput.write(string.getBytes());
                            this.logToFile(string, false);
                        }
                    }
                }
                catch (Exception exception) {
                    String string2 = "# Logger.writeToStream error: " + exception;
                    System.err.println(string2);
                    exception.printStackTrace(System.err);
                    throw new LoggerException(string2);
                }
                this.m_logOutput.close();
                this.m_logOutput = null;
            }
        }
    }

    private void initLog(String string) {
        this.initLog(string, false);
    }

    private void initLog(String string, boolean bl) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(this.m_logFileName);
        this.m_currentFileCalendar.setTime(new Date());
        stringBuffer.append("_").append(this.m_fileDateFormat.format(this.m_currentFileCalendar.getTime())).append(".txt");
        String string3 = string;
        if (string3 == null) {
            string3 = this.m_outputDir;
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        this.m_outputDir = string3;
        stringBuffer = new StringBuffer(string3).append(stringBuffer);
        this.m_logFile = new File(stringBuffer.toString());
        String string4 = stringBuffer.toString();
        if (bl && this.m_logFile.exists()) {
            int n = 1;
            String string5 = string4;
            string5 = string5.substring(0, string5.length() - 4);
            string2 = string5 + "_" + n + ".txt";
            File file = new File(string2);
            while (file.exists() && file.length() > this.m_maxLogSize) {
                string2 = string5 + "_" + ++n + ".txt";
                file = new File(string2);
            }
            string4 = string2;
            this.m_logFile = new File(string4);
        }
        this.m_currentLogFileName = string4;
        try {
            this.m_logOutput = new PrintWriter(new FileWriter(string4, true));
        }
        catch (Exception exception) {
            try {
                this.m_logOutput = new PrintWriter(new FileWriter(string4));
            }
            catch (Exception exception2) {
                string2 = new StringBuffer("# EXC during creation of the Log for '").append(string4).append("'").toString();
                System.err.println(string2);
                exception2.printStackTrace();
                throw new LoggerException(string2);
            }
        }
        if (!bl) {
            Logger.instance().log(4, "\n--------------------------------------------------------------------------------\n");
            Logger.instance().log(4, "Log file created at : " + string4);
        }
    }

    private void logToFile(String string) {
        this.logToFile(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String string, boolean bl) {
        if (this.m_logOutput == null) {
            this.initLog();
        }
        try {
            PrintWriter printWriter = this.m_logOutput;
            synchronized (printWriter) {
                if (bl && this.m_logFile.length() > this.m_maxLogSize) {
                    this.restartLog();
                    this.initLog(null, true);
                    this.logToFile(string);
                    return;
                }
                this.m_logOutput.write(string);
                this.m_logOutput.flush();
            }
        }
        catch (Exception exception) {
            String string2 = "# EXC during log : " + exception;
            System.err.println(string2);
            exception.printStackTrace(System.err);
            throw new LoggerException(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(Throwable throwable) {
        if (this.m_logOutput == null) {
            this.initLog();
        }
        try {
            PrintWriter printWriter = this.m_logOutput;
            synchronized (printWriter) {
                throwable.printStackTrace(this.m_logOutput);
                this.m_logOutput.flush();
            }
        }
        catch (Exception exception) {
            String string = "# EXC during log : " + exception;
            System.err.println(string);
            exception.printStackTrace(System.err);
            throw new LoggerException(string);
        }
    }

    private void writeToStream(String string) {
        if (!this.m_loggingEnabled) {
            return;
        }
        if (this.m_userOutput == null) {
            this.m_userOutput = System.err;
        }
        try {
            switch (this.m_logType) {
                case 15: {
                    this.m_userOutput.print(string);
                    break;
                }
                case 14: {
                    this.logToFile(string);
                    break;
                }
                case 16: {
                    this.m_userOutput.print(string);
                    this.logToFile(string);
                }
            }
        }
        catch (Exception exception) {
            String string2 = "# Logger.writeToStream error: " + exception;
            System.err.println(string2);
            exception.printStackTrace(System.err);
            throw new LoggerException(string2);
        }
    }

    private void writeToStream(Throwable throwable) {
        if (!this.m_loggingEnabled) {
            return;
        }
        if (this.m_userOutput == null) {
            this.m_userOutput = System.err;
        }
        try {
            switch (this.m_logType) {
                case 15: {
                    throwable.printStackTrace(this.m_userOutput);
                    break;
                }
                case 14: {
                    this.logToFile(throwable);
                    break;
                }
                case 16: {
                    throwable.printStackTrace(this.m_userOutput);
                    this.logToFile(throwable);
                }
            }
        }
        catch (Exception exception) {
            String string = "# Logger.writeToStream error: " + exception;
            System.err.println(string);
            exception.printStackTrace(System.err);
            throw new LoggerException(string);
        }
    }

    public String getLogFileName() {
        if (this.m_currentLogFileName == null) {
            return "";
        }
        return this.m_currentLogFileName;
    }

    public static void main(String[] stringArray) {
    }
}

