/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import weblogic.auddi.util.IntervalTimer;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyFileException;
import weblogic.auddi.util.PropertyHolderImpl;
import weblogic.auddi.util.TimerListener;

public class PersistentPropertyHolder
extends PropertyHolderImpl {
    private boolean m_isChanged = false;
    private long m_interval = 5000L;
    private boolean m_initialized = false;
    private String m_header = "A property file used by AUDDI";
    private String m_fileName = null;
    private static String s_headerPrefix = "###################################################################\n#\n#  AUDDI Configuration File\n#\n#  Created : ";
    private static String s_headerSuffix = "\n#\n###################################################################\n\n";
    private static SimpleDateFormat s_sdf = new SimpleDateFormat("yyyyy.MMMMM.dd GGG hh:mm aaa");

    public PersistentPropertyHolder(String string) throws PropertyFileException {
        Logger.trace("+PersistentPropertyHolder.CTOR()");
        this.init(string);
        Logger.trace("-PersistentPropertyHolder.CTOR()");
    }

    public PersistentPropertyHolder(String string, Properties properties) throws PropertyFileException {
        super(properties);
        Logger.trace("+PersistentPropertyHolder.CTOR()");
        this.init(string);
        Logger.trace("-PersistentPropertyHolder.CTOR()");
    }

    private void init(String string) throws PropertyFileException {
        this.m_fileName = string;
        this.loadFile();
        this.updateFile();
        IntervalTimer intervalTimer = new IntervalTimer(new TimerListener(){

            public void onTimer() {
                try {
                    PersistentPropertyHolder.this.updateFile();
                }
                catch (PropertyFileException propertyFileException) {
                    throw new IllegalStateException(propertyFileException.getMessage());
                }
            }
        }, this.m_interval);
        intervalTimer.start();
    }

    public String setProperty(String string, String string2) {
        Logger.trace("+PersistentPropertyHolder.setProperty()");
        this.m_isChanged = true;
        String string3 = super.setProperty(string, string2);
        Logger.trace("-PersistentPropertyHolder.setProperty()");
        return string3;
    }

    private void loadFile() throws PropertyFileException {
        try {
            File file = new File(this.m_fileName);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.m_props.load(fileInputStream);
                fileInputStream.close();
            } else {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw new PropertyFileException("Error creating/reading property file: [" + this.m_fileName + "]");
        }
    }

    private void updateFile() throws PropertyFileException {
        if (this.m_isChanged) {
            try {
                FileWriter fileWriter = new FileWriter(this.m_fileName);
                Object[] objectArray = this.m_props.keySet().toArray();
                Arrays.sort(objectArray);
                fileWriter.write(PersistentPropertyHolder.getHeader());
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    String string2 = (String)this.m_props.get(string);
                    fileWriter.write(string + "=" + string2 + "\n");
                }
                fileWriter.flush();
                fileWriter.close();
                this.m_isChanged = false;
                Logger.info("AUDDI configuration changes have been saved to properties file.");
            }
            catch (IOException iOException) {
                throw new PropertyFileException("Unable to update Property file: " + this.m_fileName);
            }
        }
    }

    public static void main(String[] stringArray) throws PropertyFileException, InterruptedException {
        PersistentPropertyHolder persistentPropertyHolder = new PersistentPropertyHolder("uddi.properties");
        int n = 0;
        while (n < 4) {
            persistentPropertyHolder.setProperty("test" + ++n, "test value" + n);
        }
    }

    private static String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(s_headerPrefix);
        stringBuffer.append(s_sdf.format(new Date()));
        stringBuffer.append(s_headerSuffix);
        return stringBuffer.toString();
    }
}

