/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PersistentPropertyHolder;
import weblogic.auddi.util.PropertyFileException;
import weblogic.auddi.util.PropertyHolder;
import weblogic.auddi.util.PropertyHolderImpl;
import weblogic.auddi.util.Util;

public class PropertyManager {
    private static PropertyHolder m_perProps = null;
    private static PropertyHolder m_runProps = new PropertyHolderImpl();
    private static String m_propFile = null;

    private PropertyManager() {
    }

    public static String getPersistentProperty(String string) {
        if (m_perProps == null) {
            throw new IllegalStateException("Properties have not been initialized.");
        }
        return m_perProps.getProperty(string);
    }

    public static void setPersistentProperty(String string, String string2) {
        if (m_perProps == null) {
            throw new IllegalStateException("Properties have not been initialized.");
        }
        m_perProps.setProperty(string, string2);
    }

    public static void setPersistentProperty(String string, String string2, boolean bl) {
        if (!bl && PropertyManager.getPersistentProperty(string) != null) {
            return;
        }
        PropertyManager.setPersistentProperty(string, string2);
    }

    public static String getRuntimeProperty(String string) {
        return m_runProps.getProperty(string);
    }

    public static void setRuntimeProperty(String string, String string2) {
        PropertyManager.setRuntimeProperty(string, string2, true);
    }

    public static void setRuntimeProperty(String string, String string2, boolean bl) {
        Logger.trace(">>>  PropertyManager.setRuntimeProperty(), " + string + " : " + string2 + "(" + (bl ? "Replace" : "Don't replace") + ")");
        if (!bl && PropertyManager.getRuntimeProperty(string) != null) {
            return;
        }
        m_runProps.setProperty(string, string2);
    }

    public static PropertyHolder getRuntimePropertyHolder() {
        return m_runProps;
    }

    public static PropertyHolder getPersistentPropertyHolder() {
        if (m_perProps == null) {
            throw new IllegalStateException("Properties have not been initialized.");
        }
        return m_perProps;
    }

    public static void initialize(String string) throws PropertyFileException {
        PropertyManager.initialize(string, null);
    }

    public static void initialize(String string, String string2) throws PropertyFileException {
        Logger.trace("+PropertyManager.initialize()");
        Logger.trace("propFile : " + string);
        Logger.trace("propFileDefault : " + string2);
        if (m_perProps != null) {
            throw new IllegalStateException("Properties have already been initialized.");
        }
        if (string2 != null) {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new PropertyFileException("Did not find default property file.");
            }
            m_perProps = new PersistentPropertyHolder(string, properties);
        } else {
            m_perProps = new PersistentPropertyHolder(string);
        }
        m_propFile = string;
        PropertyManager.updateRuntimeProperties();
        Logger.trace("-PropertyManager.initialize()");
    }

    private static void updateRuntimeProperties() {
        Enumeration enumeration = m_perProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            m_runProps.setProperty(string, m_perProps.getProperty(string));
        }
    }

    public static void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        m_runProps.addProperties(properties, false);
    }

    public static void load(ResourceBundle resourceBundle) throws IOException {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.setProperty(string, resourceBundle.getString(string));
        }
        m_runProps.addProperties(properties, false);
    }

    public static void loadAsFile(String string) throws PropertyFileException {
        Logger.trace("+PropertyManager.loadAsFile()");
        Logger.debug("PropertyManager:  loading: " + string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            PropertyManager.load(fileInputStream);
        }
        catch (IOException iOException) {
            Logger.trace("-EXCEPTION(PropertyFileException) PropertyManager.loadAsFile()");
            throw new PropertyFileException(UDDIMessages.get("error.fatalError.fileNotfound.2", string));
        }
        Logger.trace("-PropertyManager.loadAsFile()");
    }

    public static void loadAsResource(String string) throws PropertyFileException {
        PropertyManager.loadAsResource(string, null, false);
    }

    public static void loadAsResource(String string, String string2) throws PropertyFileException {
        PropertyManager.loadAsResource(string, string2, false);
    }

    /*
     * Unable to fully structure code
     */
    public static void loadAsResource(String var0, String var1_1, boolean var2_2) throws PropertyFileException {
        Logger.trace("+PropertyManager.loadAsResource()");
        Logger.debug("PropertyManager:  loading: " + var0 + " (prefix:" + var1_1 + ")");
        var3_3 = null;
        try {
            var3_3 = PropertyManager.class.getResourceAsStream(var0);
            if (var3_3 == null) {
                PropertyManager.class.getClassLoader();
                var3_3 = ClassLoader.getSystemResourceAsStream(var0);
            }
            if (var3_3 != null) ** GOTO lbl-1000
            var4_4 = var0.substring(1, var0.indexOf(".properties"));
            Logger.debug("finding resource bundle : " + var4_4);
            try {
                var5_7 = Util.getResource(var4_4);
                Logger.debug("bundle : " + var5_7);
                PropertyManager.load(var5_7);
                return;
            }
            catch (MissingResourceException var5_8) {
                try lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        if (var1_1 != null) {
                            var0 = var1_1 + var0;
                            Logger.debug("didn't find it, loading : " + var0);
                            var3_3 = PropertyManager.class.getResourceAsStream(var0);
                            if (var3_3 == null) {
                                PropertyManager.class.getClassLoader();
                                var3_3 = ClassLoader.getSystemResourceAsStream(var0);
                            }
                        }
                        if (var3_3 == null) {
                            Logger.trace("-EXCEPTION(PropertyFileException) PropertyManager.loadAsResource()");
                            throw new PropertyFileException(UDDIMessages.get("error.fatalError.fileNotfound.2", var0));
                        }
                    }
                    PropertyManager.load(var3_3);
                }
                catch (IOException var4_6) {
                    Logger.trace("-EXCEPTION(PropertyFileException) PropertyManager.loadAsResource()");
                    throw new PropertyFileException(UDDIMessages.get("error.fatalError.fileNotfound.2", var0));
                }
                catch (Throwable var7_10) {
                    throw var7_10;
                }
            }
        }
        finally {
            if (var3_3 != null) {
                try {
                    var3_3.close();
                }
                catch (IOException var8_11) {}
            }
        }
        Logger.trace("-PropertyManager.loadAsResource()");
    }

    public static void backUpPropfile() throws FatalErrorException {
        Logger.trace("+PropertyManager.backUpPropfile()");
        if (m_propFile == null) {
            return;
        }
        try {
            Logger.debug(">>> create back up file: " + m_propFile + ".booted");
            FileOutputStream fileOutputStream = new FileOutputStream(m_propFile + ".booted");
            FileInputStream fileInputStream = new FileInputStream(m_propFile);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            properties.store(fileOutputStream, "# backup of last booted");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Logger.trace("-EXCEPTION(IOException) PropertyManager.backUpPropfile()");
            throw new FatalErrorException("Failed to back up property file: " + m_propFile, iOException);
        }
        Logger.trace("-PropertyManager.backUpPropfile()");
    }
}

