/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class Util {
    public static void saveToFile(String string, String string2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
        printWriter.println(string);
        printWriter.close();
    }

    public static String getFileContent(String string) throws IOException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2.trim());
        }
        return stringBuffer.toString();
    }

    public static String getFileContentWithLines(String string) throws IOException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2.trim()).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getFileContent(File file) throws IOException {
        String string;
        if (file == null) {
            throw new IllegalArgumentException("fileName was null");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    public static String getStreamContent(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    public static String fixStringForXML(String string) {
        string = Util.replaceWithException(string, "&", "&amp;");
        string = Util.replace(string, "<", "&lt;");
        string = Util.replace(string, ">", "&gt;");
        string = Util.replace(string, "\"", "&quot;");
        return string;
    }

    public static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean isEqual(Object[] objectArray, Object[] objectArray2) {
        return objectArray == null ? objectArray2 == null : Arrays.equals(objectArray, objectArray2);
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n ^= objectArray[i].hashCode();
        }
        return n;
    }

    public static String quoteMessage(String string) {
        if (!string.startsWith("'")) {
            return "'" + string + "'";
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        String string4 = null;
        while ((n = string.indexOf(string2)) != -1) {
            if (string4 == null) {
                string4 = "";
            }
            string4 = string4 + string.substring(0, n) + string3;
            string = string.substring(n + string2.length());
        }
        string4 = string4 == null ? string : string4 + string;
        return string4;
    }

    public static String replaceWithException(String string, String string2, String string3, String string4) {
        int n;
        String string5 = null;
        while ((n = string.indexOf(string2)) != -1) {
            if (string5 == null) {
                string5 = "";
            }
            if (string.substring(n).startsWith(string4)) {
                string5 = string5 + string.substring(0, n + string4.length());
                string = string.substring(n + string4.length());
                continue;
            }
            string5 = string5 + string.substring(0, n) + string3;
            string = string.substring(n + string2.length());
        }
        string5 = string5 == null ? string : string5 + string;
        return string5;
    }

    public static String replaceWithException(String string, String string2, String string3) {
        return Util.replaceWithException(string, string2, string3, string3);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String getOSName() {
        return System.getProperty("os.name").replace(' ', '_');
    }

    public static String space(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int getResourceSize(ResourceBundle resourceBundle) {
        int n = 0;
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    public static void printNames(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = null;
                if (objectArray[i] != null) {
                    string = objectArray[i].toString();
                }
                System.err.println("  " + i + " : " + string);
            }
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(stringWriter));
        printWriter.println(throwable.getMessage());
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private Util() {
    }

    public static String[] getPair(String string, String string2) {
        String[] stringArray = new String[2];
        int n = string.indexOf(string2);
        stringArray[0] = string.substring(0, n).trim();
        stringArray[1] = string.substring(n + string2.length()).trim();
        return stringArray;
    }

    public static String[] getPair(String string) {
        return Util.getPair(string, "=");
    }

    public static ResourceBundle getResource(Class clazz) {
        String string = clazz.getName();
        return Util.getResource(Util.insertResourceInString(string));
    }

    public static ResourceBundle getResource(Object object) {
        String string = object.getClass().getName();
        return Util.getResource(Util.insertResourceInString(string));
    }

    public static ResourceBundle getResource(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        return resourceBundle;
    }

    private static String insertResourceInString(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        string = string2 + ".resources." + string3;
        return string;
    }

    public static String compactFile(String string) throws IOException {
        String string2 = Util.getFileContent(string);
        return string2;
    }

    public static void main(String[] stringArray) {
    }
}

