/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util.uuid;

import java.security.SecureRandom;
import weblogic.auddi.util.uuid.UUIDTimer;

public class UUIDGen {
    private final SecureRandom rnd = new SecureRandom();
    private UUIDTimer timer = new UUIDTimer(this.rnd);
    private final String hexChars = "0123456789abcdef";
    private final Object lock = new Object();

    public static void main(String[] stringArray) {
        String string;
        int n;
        int n2 = Integer.parseInt(stringArray[0]);
        System.out.println("here 1");
        UUIDGen uUIDGen = new UUIDGen();
        System.out.println("here 2");
        System.out.println("==========TimeBasedUUIDWithRandomNode============");
        for (n = 0; n < n2; ++n) {
            string = uUIDGen.generateTimeBasedUUIDWithRandomNode();
            System.out.print("UUID: ");
            System.out.println(string);
        }
        System.out.println("here 3");
        System.out.println("==========RandomBasedUUID============");
        for (n = 0; n < n2; ++n) {
            string = uUIDGen.generateRandomBasedUUID();
            System.out.print("UUID: ");
            System.out.println(string);
        }
        System.out.println("here 4");
        System.out.println("==========TimeBasedUUID============");
        for (n = 0; n < n2; ++n) {
            string = uUIDGen.generateTimeBasedUUID("00ab3fd234f3");
            System.out.print("UUID: ");
            System.out.println(string);
        }
        System.out.println("here 5");
    }

    private boolean isValid(String string) {
        boolean bl = false;
        byte[] byArray = string.getBytes();
        if (byArray.length == 12) {
            for (int i = 0; i < 12; ++i) {
                if ((byArray[i] <= 47 || byArray[i] >= 58) && (byArray[i] <= 96 || byArray[i] >= 123)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private String generateRandomNodeNumber() {
        byte[] byArray = new byte[6];
        this.rnd.nextBytes(byArray);
        byArray[0] = (byte)(byArray[0] | 0x80);
        StringBuffer stringBuffer = new StringBuffer(12);
        for (int i = 0; i < 6; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append("0123456789abcdef".charAt(n >> 4));
            stringBuffer.append("0123456789abcdef".charAt(n & 0xF));
        }
        return stringBuffer.toString();
    }

    public String generateRandomBasedUUID() {
        byte[] byArray = new byte[16];
        this.rnd.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        StringBuffer stringBuffer = new StringBuffer(36);
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    stringBuffer.append('-');
                }
            }
            int n = byArray[i] & 0xFF;
            stringBuffer.append("0123456789abcdef".charAt(n >> 4));
            stringBuffer.append("0123456789abcdef".charAt(n & 0xF));
        }
        return stringBuffer.toString();
    }

    public String generateTimeBasedUUIDWithRandomNode() {
        String string = this.generateRandomNodeNumber();
        return this.generateTimeBasedUUID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateTimeBasedUUID(String string) {
        if (!this.isValid(string)) {
            string = this.generateRandomNodeNumber();
        }
        byte[] byArray = new byte[10];
        Object object = this.lock;
        synchronized (object) {
            this.timer.getTimestamp(byArray);
        }
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x10);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        object = new StringBuffer(23);
        for (int i = 0; i < 10; ++i) {
            switch (i) {
                case 4: 
                case 6: 
                case 8: {
                    ((StringBuffer)object).append('-');
                }
            }
            int n = byArray[i] & 0xFF;
            ((StringBuffer)object).append("0123456789abcdef".charAt(n >> 4));
            ((StringBuffer)object).append("0123456789abcdef".charAt(n & 0xF));
        }
        return ((StringBuffer)object).toString() + "-" + string;
    }
}

