/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util.uuid;

import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.util.uuid.UUIDException;
import weblogic.auddi.util.uuid.UUIDGenerator;

public abstract class UUIDGeneratorFactory {
    private static String s_uuidClassName = null;
    private static Class s_uuidClass = null;
    private static final String UUID_GEN_CLASS_NAME_PROPERTY = "uuidgen.class";
    private static final String DEFAULT_UUID_GEN_CLASS_NAME = "weblogic.auddi.util.uuid.JavaUUIDGenerator";
    public static final String UUID_ENV_PREFIX = "uuidgen.";
    private static UUIDGenerator s_instance = null;

    public static void reset() {
        s_uuidClassName = null;
        s_uuidClass = null;
        s_instance = null;
    }

    private UUIDGeneratorFactory() {
    }

    public static UUIDGenerator getGenerator() throws UUIDException {
        Logger.trace("+UUIDGeneratorFactory.getUUIDGenerator()");
        if (s_instance == null) {
            if (s_uuidClass == null) {
                s_uuidClass = UUIDGeneratorFactory.loadClass();
            }
            try {
                s_instance = (UUIDGenerator)s_uuidClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                Logger.error("Exception while attempting to instantiate subclass of UUIDGenerator: " + s_uuidClassName);
                instantiationException.printStackTrace();
                Logger.trace("-UUIDGeneratorFactory.getUUIDGenerator()");
                throw new UUIDException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.error("Exception while attempting to instantiate subclass of UUIDGenerator: " + s_uuidClassName);
                illegalAccessException.printStackTrace();
                Logger.trace("-UUIDGeneratorFactory.getUUIDGenerator()");
                throw new UUIDException(illegalAccessException);
            }
        }
        Logger.trace("-UUIDGeneratorFactory.getUUIDGenerator()");
        return s_instance;
    }

    private static synchronized Class loadClass() throws UUIDException {
        Logger.trace("+UUIDGeneratorFactory.loadClass()");
        s_uuidClassName = PropertyManager.getRuntimeProperty(UUID_GEN_CLASS_NAME_PROPERTY);
        Class<?> clazz = null;
        if (s_uuidClassName == null) {
            s_uuidClassName = DEFAULT_UUID_GEN_CLASS_NAME;
        }
        try {
            clazz = Class.forName(s_uuidClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.error("Subclass of UUIDGenerator not found in classpath: " + s_uuidClassName + " not found.");
            classNotFoundException.printStackTrace();
            Logger.trace("-UUIDGeneratorFactory.loadClass()");
            throw new UUIDException(classNotFoundException);
        }
        Logger.trace("-UUIDGeneratorFactory.loadClass()");
        return clazz;
    }
}

