/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.util.uuid;

import java.security.SecureRandom;

public class UUIDTimer {
    private static final long clockOffset = 122192928000000000L;
    private static final long clockMultiplier = 10000L;
    private static final long clockMultiplierL = 10000L;
    private final SecureRandom rnd;
    private final byte[] clockSequence = new byte[2];
    private long lastTimeStamp = 0L;
    private int clockCounter = 0;

    public UUIDTimer(SecureRandom secureRandom) {
        this.rnd = secureRandom;
        this.initTimeStamps();
    }

    private void initTimeStamps() {
        this.rnd.nextBytes(this.clockSequence);
        byte[] byArray = new byte[1];
        this.rnd.nextBytes(byArray);
        this.clockCounter = byArray[0] & 0xFF;
        this.lastTimeStamp = 0L;
    }

    public void getTimestamp(byte[] byArray) {
        byArray[8] = this.clockSequence[0];
        byArray[9] = this.clockSequence[1];
        long l = System.currentTimeMillis();
        if (l < this.lastTimeStamp) {
            this.initTimeStamps();
        } else if (l == this.lastTimeStamp) {
            if ((long)this.clockCounter == 10000L) {
                byte[] byArray2 = new byte[1];
                this.rnd.nextBytes(byArray2);
                this.clockCounter = byArray2[0] & 0xFF;
                do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((l = System.currentTimeMillis()) == this.lastTimeStamp);
                this.lastTimeStamp = l;
            }
        } else {
            this.clockCounter &= 0xFF;
            this.lastTimeStamp = l;
        }
        l *= 10000L;
        l += 122192928000000000L;
        int n = (int)((l += (long)this.clockCounter) >>> 32);
        int n2 = (int)l;
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)n2;
        byArray[4] = (byte)(n >>> 8);
        byArray[5] = (byte)n;
        byArray[6] = (byte)(n >>> 24);
        byArray[7] = (byte)(n >>> 16);
        ++this.clockCounter;
    }
}

