/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLParser;
import weblogic.auddi.xml.XMLUtil;

public class DomBuilder
extends XMLParser
implements ErrorHandler {
    private static final int READ_AHEAD_LIMIT = 100;
    private SAXParseException m_SAXParseException;
    private DocumentBuilder m_parser;
    private String m_encoding;

    public DomBuilder(DocumentBuilder documentBuilder) {
        Logger.trace("+DomBuilder.CTOR()");
        Logger.debug("DomBuilder.Class: " + documentBuilder.getClass().getName());
        this.m_parser = documentBuilder;
        this.m_parser.setErrorHandler(this);
        Logger.trace("-DomBuilder.CTOR()");
    }

    public Document parseRequest(String string) throws SchemaException {
        try {
            return this.parse(string);
        }
        catch (SAXException sAXException) {
            throw new SchemaException(sAXException);
        }
        catch (IOException iOException) {
            throw new SchemaException(iOException);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.m_parser.setEntityResolver(entityResolver);
    }

    public Document parse(String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(string));
        return this.parse(inputSource);
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        Logger.trace("+DomBuilder.parse()");
        this.m_SAXParseException = null;
        this.m_encoding = this.readEncoding(inputSource);
        Document document = this.m_parser.parse(inputSource);
        if (this.m_SAXParseException != null) {
            throw this.m_SAXParseException;
        }
        XMLUtil.removeWhiteSpace(document);
        Logger.trace("-DomBuilder.parse()");
        return document;
    }

    String getEncoding() {
        return this.m_encoding;
    }

    public void warning(SAXParseException sAXParseException) {
        Logger.trace("+DomBuilder.warning");
        Logger.trace("-DomBuilder.warning");
    }

    public void error(SAXParseException sAXParseException) {
        Logger.trace("+DomBuilder.error()");
        Logger.debug(sAXParseException);
        this.m_SAXParseException = sAXParseException;
        Logger.trace("-DomBuilder.error()");
    }

    public void fatalError(SAXParseException sAXParseException) {
        Logger.trace("+DomBuilder.fatalError()");
        Logger.debug(sAXParseException);
        this.m_SAXParseException = sAXParseException;
        Logger.trace("-DomBuilder.fatalError()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEncoding(InputSource inputSource) {
        String string = null;
        Reader reader = null;
        try {
            reader = inputSource.getCharacterStream();
            reader.mark(100);
            char[] cArray = new char[100];
            reader.read(cArray);
            string = new String(cArray);
            string = string.substring(0, string.indexOf(62) + 1);
            int n = string.indexOf("encoding");
            if (n == -1) {
                string = null;
            } else {
                string = string.substring(n + 8);
                int n2 = string.indexOf(34);
                int n3 = string.indexOf(34, n2 + 1);
                if (n2 == -1) {
                    n2 = string.indexOf("'");
                    n3 = string.indexOf("'", n2 + 1);
                }
                string = string.substring(n2 + 1, n3);
            }
            String string2 = string;
            return string2;
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                reader.reset();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

