/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;

class ParserBuilder {
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private DocumentBuilderFactory m_vFactory;
    private DocumentBuilderFactory m_nvFactory;

    public ParserBuilder(String string) {
        Logger.trace("+ParserBuilder.CTOR(String) - JAXPFactory: " + string);
        if (string == null || string.length() == 0) {
            this.m_vFactory = DocumentBuilderFactory.newInstance();
            this.m_nvFactory = DocumentBuilderFactory.newInstance();
        } else {
            try {
                this.m_vFactory = (DocumentBuilderFactory)Class.forName(string).newInstance();
                this.m_nvFactory = (DocumentBuilderFactory)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(UDDIMessages.get("error.class.notfound", new String[]{string}));
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(UDDIMessages.get("error.class.instantiation", new String[]{string}));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(UDDIMessages.get("error.class.access", new String[]{string}));
            }
        }
        this.m_nvFactory.setIgnoringElementContentWhitespace(true);
        this.m_nvFactory.setValidating(false);
        this.m_nvFactory.setNamespaceAware(false);
        this.m_nvFactory.setIgnoringComments(true);
        this.m_vFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        this.m_vFactory.setIgnoringElementContentWhitespace(true);
        this.m_vFactory.setValidating(true);
        this.m_vFactory.setNamespaceAware(true);
        this.m_vFactory.setIgnoringComments(true);
        Logger.trace("-ParserBuilder.CTOR(String)");
    }

    public DocumentBuilder createParser(String string) throws ParserConfigurationException {
        Logger.trace("+ParserBuilder.createParser(String)");
        if (string != null) {
            Logger.trace("-ParserBuilder.createParser(String)");
            return this.createParser(string, true);
        }
        Logger.trace("-ParserBuilder.createParser(String)");
        return this.createParser(string, false);
    }

    public DocumentBuilder createParser(String string, boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory;
        Logger.trace("+ParserBuilder.createParser(String, boolean)");
        if (string != null) {
            this.m_vFactory.setAttribute(JAXP_SCHEMA_SOURCE, string);
            documentBuilderFactory = this.m_vFactory;
        } else {
            documentBuilderFactory = this.m_nvFactory;
            documentBuilderFactory.setNamespaceAware(bl);
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(null);
        Logger.trace("-ParserBuilder.createParser(String, boolean)");
        return documentBuilder;
    }
}

