/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.auddi.xml.DomBuilder;
import weblogic.auddi.xml.ParserBuilder;
import weblogic.auddi.xml.SOAPParser;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLEntityResolver;

public class ParserFactory {
    public static final String ACUMEN_JAXP_FACTORY = "acumenat.jaxp.DocumentBuilderFactory.class";
    private ParserBuilder builder;
    private String jaxpFactoryClass;

    public ParserFactory(String string) {
        Logger.trace("+ParserFactory.CTOR(String)");
        this.jaxpFactoryClass = string;
        Logger.trace("-ParserFactory.CTOR(String)");
    }

    public ParserFactory() {
        this(PropertyManager.getRuntimeProperty(ACUMEN_JAXP_FACTORY));
    }

    public SOAPParser createSOAPParser() throws SchemaException {
        Logger.trace("+ParserFactory.createSOAPParser");
        DomBuilder domBuilder = this.createDOMParser("/soap-envelope.xsd");
        Logger.trace("-ParserFactory.createSOAPParser");
        return new SOAPParser(domBuilder);
    }

    public DomBuilder createDOMParser(String string) throws SchemaException {
        Logger.trace("+ParserFactory.createDOMParser(String)");
        try {
            this.initBuilder();
            DocumentBuilder documentBuilder = this.builder.createParser(string);
            if (string != null) {
                documentBuilder.setEntityResolver(new XMLEntityResolver());
            }
            Logger.trace("-ParserFactory.createDOMParser(String)");
            return new DomBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SchemaException(parserConfigurationException);
        }
    }

    public DomBuilder createDOMParser() throws SchemaException {
        Logger.trace("+ParserFactory.createDOMParser()");
        DomBuilder domBuilder = this.createDOMParser(null);
        Logger.trace("-ParserFactory.createDOMParser()");
        return domBuilder;
    }

    public DomBuilder createDOMParserNS() throws SchemaException {
        Logger.trace("+ParserFactory.createDOMParserNS");
        try {
            this.initBuilder();
            DocumentBuilder documentBuilder = this.builder.createParser(null, true);
            Logger.trace("-ParserFactory.createDOMParserNS");
            return new DomBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SchemaException(parserConfigurationException);
        }
    }

    private void initBuilder() {
        Logger.trace("+ParserFactory.initBuilder()");
        if (this.builder == null) {
            this.builder = new ParserBuilder(this.jaxpFactoryClass);
        }
        Logger.trace("-ParserFactory.initBuilder()");
    }
}

