/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.auddi.uddi.UDDIMessages;
import weblogic.auddi.util.Logger;
import weblogic.auddi.xml.DomBuilder;
import weblogic.auddi.xml.SchemaException;
import weblogic.auddi.xml.XMLParser;
import weblogic.auddi.xml.XMLUtil;

public class SOAPParser
extends XMLParser {
    private DomBuilder m_parser;
    private boolean m_hasFault;
    private Node m_faultNode;

    public SOAPParser(DomBuilder domBuilder) throws SchemaException {
        Logger.trace("+SOAPParser.CTOR()");
        this.m_parser = domBuilder;
        Logger.trace("-SOAPParser.CTOR()");
    }

    public Document parseRequest(String string) throws SchemaException {
        try {
            Logger.trace("+SOAPParser.parseRequest()");
            Document document = this.m_parser.parse(new InputSource(new StringReader(string)));
            Logger.trace("-SOAPParser.parseRequest()");
            return document;
        }
        catch (SAXException sAXException) {
            Logger.trace("-EXCEPTION(SchemaException) SOAPParser.parseRequest()");
            throw new SchemaException(sAXException);
        }
        catch (IOException iOException) {
            Logger.trace("-EXCEPTION(IOException) SOAPParser.parseRequest()");
            throw new SchemaException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.trace("-EXCEPTION(IllegalArgumentException) SOAPParser.parseRequest()");
            throw new SchemaException(illegalArgumentException.getMessage());
        }
    }

    public String getPayLoad(Document document) {
        Logger.trace("+SOAPParser.getPayLoad()");
        Node node = this.getPayLoadNode(document);
        String string = null;
        if (node != null) {
            string = XMLUtil.nodeToString(node);
        }
        Logger.trace("-SOAPParser.getPayLoad()");
        return string;
    }

    public Node getPayLoadNode(Document document) {
        Node node;
        int n;
        int n2;
        Logger.trace("+SOAPParser.getPayLoadNode()");
        NodeList nodeList = document.getElementsByTagNameNS("*", "Fault");
        if (nodeList.getLength() == 0) {
            nodeList = document.getElementsByTagNameNS("*", "Body");
        } else {
            this.m_hasFault = true;
            n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                node = nodeList.item(n);
                if (!node.getLocalName().equals("Fault")) continue;
                this.m_faultNode = node;
                break;
            }
            nodeList = document.getElementsByTagNameNS("*", "detail");
        }
        if (nodeList.getLength() > 1) {
            throw new RuntimeException(UDDIMessages.get("error.soap.toomanychildren"));
        }
        nodeList = nodeList.item(0).getChildNodes();
        node = null;
        n2 = nodeList.getLength();
        for (n = 0; n < n2 && (node = nodeList.item(n)).getNodeType() != 1; ++n) {
        }
        Logger.trace("-SOAPParser.getPayLoadNode()");
        return node;
    }

    public boolean hasFault() {
        return this.m_hasFault;
    }

    public Node getFaultNode() {
        return this.m_faultNode;
    }

    public String getEncoding() {
        return this.m_parser.getEncoding();
    }
}

