/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDumper {
    private static int INDENT = 2;
    private PrintStream m_out;
    private boolean printEntityReference;
    private boolean printComment;
    private boolean printEmptyContent;

    public XMLDumper() {
        this(System.out);
    }

    public XMLDumper(String string) throws FileNotFoundException {
        this(new PrintStream(new FileOutputStream(string)));
    }

    public XMLDumper(PrintStream printStream) {
        this.m_out = printStream;
        this.printEntityReference = false;
        this.printComment = false;
        this.printEmptyContent = false;
    }

    public void includeComments(boolean bl) {
        this.printComment = bl;
    }

    public void includeEntityReference(boolean bl) {
        this.printEntityReference = bl;
    }

    public void includeEmptyContent(boolean bl) {
        this.printEmptyContent = bl;
    }

    public void printNode(Node node) {
        if (node == null) {
            return;
        }
        this.printNode(node, 0);
    }

    private void printNode(Node node, int n) {
        this.dumpNode(node, n);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            this.printNode(nodeList.item(i), n + INDENT);
        }
    }

    private void dumpNode(Node node, int n) {
        switch (node.getNodeType()) {
            case 5: {
                if (!this.printEntityReference) {
                    return;
                }
                this.printElement(node, n);
                this.printAttributes(node, n);
                break;
            }
            case 8: {
                if (!this.printComment) {
                    return;
                }
                this.printComment(node, n);
                break;
            }
            case 3: {
                String string = this.getNodeValue(node);
                if (!this.printEmptyContent && (string == null || string.equals(""))) {
                    return;
                }
                this.printContent(node, n - INDENT);
                break;
            }
            default: {
                this.printElement(node, n);
                this.printAttributes(node, n);
            }
        }
    }

    private void printElement(Node node, int n) {
        String string = this.getNodeValue(node);
        this.printIndent(n);
        if (node.getNodeType() == 1) {
            this.m_out.print("Element: " + node.getNodeName());
        } else {
            this.m_out.print("Name: " + node.getNodeName());
            this.m_out.print("  Type: " + this.getNodeType(node));
        }
        if (string == null) {
            this.m_out.println();
        } else {
            this.m_out.println("  Value: \"" + string + "\"");
        }
    }

    private void printContent(Node node, int n) {
        this.printIndent(n);
        this.m_out.println("Content: " + node.getNodeValue());
    }

    private void printComment(Node node, int n) {
        this.printIndent(n);
        this.m_out.println("Comment: " + node.getNodeValue());
    }

    private void printAttributes(Node node, int n) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = namedNodeMap.item(i);
                this.printIndent(n);
                this.m_out.print("Attribute Name: " + node2.getNodeName());
                this.m_out.println("  Value: \"" + this.getNodeValue(node2) + "\"");
            }
        }
    }

    private void printIndent(int n) {
        for (int i = 0; i < n; ++i) {
            this.m_out.print(" ");
        }
    }

    private String getNodeType(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return "ATTRIBUTE";
            }
            case 4: {
                return "CDATA_SECTION";
            }
            case 8: {
                return "COMMENT";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCUMENT_TYPE";
            }
            case 1: {
                return "ELEMENT";
            }
            case 6: {
                return "ENTITY";
            }
            case 5: {
                return "ENTITY_REFERENCE";
            }
            case 12: {
                return "NOTATION";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "Not Found!!!!!!!";
    }

    private String getNodeValue(Node node) {
        String string = node.getNodeValue();
        return string == null ? null : string.trim();
    }
}

