/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;

class XMLEntityResolver
implements EntityResolver {
    private static byte[] s_soapschema;

    public XMLEntityResolver() {
        Logger.trace("+XMLEntityResolver.CTOR()");
        InputStream inputStream = null;
        if (s_soapschema == null) {
            Logger.trace("XMLEntityResolver.init");
            String string = PropertyManager.getRuntimeProperty("soap.schema.resource");
            if (string != null) {
                inputStream = this.getClass().getResourceAsStream(string);
            }
            try {
                int n;
                s_soapschema = new byte[inputStream.available()];
                int n2 = 0;
                while ((n = inputStream.read()) != -1) {
                    XMLEntityResolver.s_soapschema[n2++] = (byte)n;
                }
            }
            catch (IOException iOException) {
                Logger.debug(iOException);
            }
        }
        Logger.trace("-XMLEntityResolver.CTOR()");
    }

    public InputSource resolveEntity(String string, String string2) {
        Logger.trace("+XMLEntityResolver.resolveEntity() - systemId: " + string2);
        if (string2 == null) {
            Logger.trace("-XMLEntityResolver.resolveEntity() - systemId was NULL");
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        String string3 = PropertyManager.getRuntimeProperty("soap.schema.resource");
        if (string3 != null) {
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(s_soapschema));
        }
        Logger.trace("-XMLEntityResolver.resolveEntity() returning : " + (bufferedInputStream == null ? "Null" : "Not Null"));
        return bufferedInputStream == null ? null : new InputSource(bufferedInputStream);
    }
}

