/*
 * Decompiled with CFR 0.152.
 */
package weblogic.auddi.xml;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.auddi.xml.XMLDumper;
import weblogic.auddi.xml.XMLTextTransformer;

public class XMLUtil {
    private static XMLTextTransformer s_transformer = null;

    private static void init() {
        if (s_transformer == null) {
            s_transformer = new XMLTextTransformer();
        }
    }

    public static String getNodeValue(Node node) {
        String string = node.getNodeValue();
        return string == null ? null : string.trim();
    }

    public static void removeWhiteSpace(Node node) {
        int n;
        NamedNodeMap namedNodeMap;
        if (node == null) {
            return;
        }
        String string = node.getNodeValue();
        if (string != null) {
            node.setNodeValue(string.trim());
        }
        if ((namedNodeMap = node.getAttributes()) != null) {
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                String string2 = node2.getNodeValue();
                if (string2 == null) continue;
                node2.setNodeValue(string2.trim());
            }
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            XMLUtil.removeWhiteSpace(nodeList.item(n));
        }
    }

    public static String flatten(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '>') {
                bl = true;
                stringBuffer.append(c);
                continue;
            }
            if (c == '<') {
                bl = false;
                stringBuffer.append(c);
                continue;
            }
            if (Character.isWhitespace(c) && bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String flatten(Node node) {
        return XMLUtil.flatten(XMLUtil.nodeToString(node));
    }

    public static String getSOAPBody(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf("Body");
        if (n2 == -1) {
            return null;
        }
        while (string.charAt(n2) != '>') {
            ++n2;
        }
        if ((n = string.indexOf("Body", ++n2)) == -1) {
            return null;
        }
        while (string.charAt(n) != '<') {
            --n;
        }
        return string.substring(n2, n);
    }

    public static void printXML(Node node) {
        new XMLDumper(System.out).printNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nodeToString(Node node) {
        XMLUtil.init();
        XMLTextTransformer xMLTextTransformer = s_transformer;
        synchronized (xMLTextTransformer) {
            return s_transformer.transform(node);
        }
    }
}

