/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;

public class RefWrapper
implements Externalizable {
    private static final boolean nosoftrefs = Boolean.getBoolean("weblogicx.cache.nosoftreferences");
    private SoftReference softref;
    private Object hardref;

    public Object get() {
        if (nosoftrefs) {
            return this.hardref;
        }
        if (this.softref == null) {
            return null;
        }
        return this.softref.get();
    }

    public RefWrapper() {
    }

    public RefWrapper(Object object) {
        if (nosoftrefs) {
            this.hardref = object;
        } else {
            this.softref = new SoftReference<Object>(object);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.get());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        if (object == null) {
            return;
        }
        if (nosoftrefs) {
            this.hardref = object;
        } else {
            this.softref = new SoftReference<Object>(object);
        }
    }
}

