/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import weblogic.cache.CacheException;
import weblogic.cache.CacheValue;
import weblogic.cache.KeyEnumerator;
import weblogic.cache.webapp.CacheMonitor;
import weblogic.cache.webapp.CacheSystem;
import weblogic.cache.webapp.KeySet;
import weblogic.cache.webapp.ServletCacheUtils;
import weblogic.cache.webapp.WebAppCacheSystem;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletResponseImpl;

public class CacheFilter
implements Filter {
    public static final long MAX_CACHED_SIZE = 64000L;
    private static boolean verbose = false;
    private int timeout = -1;
    private String timeoutString;
    private String scope;
    private int size;
    private String key;
    private String vars;
    private boolean configured;
    private long maxSize = 64000L;
    private CacheMonitor cm;
    private FilterConfig config;

    protected KeySet getKeySet(CacheSystem cacheSystem) throws CacheException {
        if (this.key == null) {
            return null;
        }
        KeySet keySet = new KeySet(cacheSystem);
        KeyEnumerator keyEnumerator = new KeyEnumerator(this.key);
        while (keyEnumerator.hasMoreKeys()) {
            String string = keyEnumerator.getNextKey();
            String string2 = keyEnumerator.getKeyScope();
            keySet.addKey(string2, string);
        }
        return keySet;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        this.config = filterConfig;
        this.timeoutString = filterConfig.getInitParameter("timeout");
        this.scope = filterConfig.getInitParameter("scope");
        if (this.scope == null) {
            this.scope = "application";
        }
        if ((string = filterConfig.getInitParameter("max-cache-size")) == null) {
            this.maxSize = 64000L;
        } else {
            try {
                this.maxSize = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxSize = 64000L;
            }
        }
        String string2 = filterConfig.getInitParameter("size");
        if (string2 == null) {
            this.size = -1;
        } else {
            try {
                this.size = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.size = -1;
            }
        }
        this.key = filterConfig.getInitParameter("key");
        this.vars = filterConfig.getInitParameter("vars");
        String string3 = filterConfig.getInitParameter("verbose");
        if (string3 != null && string3.equals("true")) {
            verbose = true;
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest var1_1, ServletResponse var2_2, FilterChain var3_3) throws ServletException, IOException {
        block54: {
            block53: {
                block51: {
                    block52: {
                        block49: {
                            block50: {
                                if (CacheFilter.verbose) {
                                    System.out.println("Filter start");
                                }
                                var4_4 = new WebAppCacheSystem();
                                if (var1_1.getAttribute("weblogic.cache.tag.CacheTag.caching") != null) {
                                    throw new ServletException("Cannot cache inside another cache");
                                }
                                var1_1.setAttribute("weblogic.cache.tag.CacheTag.caching", (Object)"true");
                                var5_5 = var1_1.getAttribute("javax.servlet.include.request_uri") != null;
                                var6_7 = (HttpServletRequest)var1_1;
                                var7_8 = (HttpServletResponse)var2_2;
                                var8_9 = null;
                                var9_10 = this.config.getInitParameter("name");
                                if (var9_10 == null) {
                                    var9_10 = var6_7.getRequestURI();
                                } else {
                                    var6_7.setAttribute("uri", (Object)var6_7.getRequestURI());
                                }
                                if (this.timeout == -1 && this.timeoutString != null) {
                                    this.timeout = ServletCacheUtils.getTimeout(this.timeoutString);
                                }
                                var4_4.setRequest(var6_7);
                                var4_4.setResponse(var7_8);
                                var4_4.setContext(this.config.getServletContext());
                                var14_11 = this.getKeySet(var4_4);
                                var12_12 = this.key == null ? var4_4.getCache(this.scope, var9_10) : var4_4.getCache(this.scope, var9_10, this.size, var14_11);
                                var15_13 = -1;
                                if (var12_12 != null) ** GOTO lbl101
                                if (CacheFilter.verbose) {
                                    System.out.println("No cache found for " + var9_10);
                                }
                                var10_14 = System.currentTimeMillis();
                                var16_16 = new CacheServletResponse(var7_8, this.maxSize);
                                var17_19 = new CacheServletRequest(var6_7);
                                var3_3.doFilter((ServletRequest)var17_19, (ServletResponse)var16_16);
                                var8_9 = this.getOriginalResponse(var7_8);
                                var15_13 = var8_9.getStatus();
                                if (CacheFilter.verbose) {
                                    System.out.println("status = " + var15_13);
                                }
                                if (!var16_16.largeCL() && var16_16.isCaching()) break block49;
                                if (CacheFilter.verbose) {
                                    System.out.println("Not caching the response since it exceeded the maxSize: " + this.maxSize);
                                }
                                var18_22 = System.currentTimeMillis();
                                var20_25 = (int)(var18_22 - var10_14);
                                if (this.key == null) {
                                    var4_4.setCache(this.scope, var9_10, null, var20_25);
                                    break block50;
                                }
                                var4_4.setCache(this.scope, var9_10, this.size, var14_11, null, var20_25);
                            }
                            var1_1.removeAttribute("weblogic.cache.tag.CacheTag.caching");
                            try {
                                var4_4.releaseAllLocks();
                            }
                            catch (CacheException var21_28) {
                                throw new ServletException("Cache may be corrupt", (Throwable)var21_28);
                            }
                            return;
                        }
                        var13_32 = var16_16.getContent();
                        if (var15_13 == 200) break block51;
                        var18_23 = System.currentTimeMillis();
                        var20_26 = (int)(var18_23 - var10_14);
                        if (this.key == null) {
                            var4_4.setCache(this.scope, var9_10, null, var20_26);
                        } else {
                            var4_4.setCache(this.scope, var9_10, this.size, var14_11, null, var20_26);
                        }
                        if (var13_32 == null || var13_32.length <= 0) break block52;
                        var2_2.setContentLength(var13_32.length);
                        try {
                            var2_2.getOutputStream().write(var13_32, 0, var13_32.length);
                        }
                        catch (IllegalStateException var21_29) {
                            var2_2.getWriter().write(new String(var13_32, var2_2.getCharacterEncoding()));
                        }
                    }
                    var1_1.removeAttribute("weblogic.cache.tag.CacheTag.caching");
                    try {
                        var4_4.releaseAllLocks();
                    }
                    catch (CacheException var21_30) {
                        throw new ServletException("Cache may be corrupt", (Throwable)var21_30);
                    }
                    return;
                }
                var18_24 = System.currentTimeMillis();
                var20_27 = (int)(var18_24 - var10_14);
                var12_12 = new CacheValue();
                var12_12.setContent(var13_32);
                var12_12.setTimeout(this.timeout);
                if (!var5_5) {
                    var21_31 = var8_9.getHeader("Content-Type");
                    if (var21_31 != null) {
                        var12_12.setAttribute("Content-Type", var21_31);
                    }
                    if ((var22_33 = var8_9.getHeader("Last-Modified")) == null) {
                        var7_8.setDateHeader("Last-Modified", var18_24);
                        var22_33 = var8_9.getHeader("Last-Modified");
                    }
                    if (var22_33 != null) {
                        var12_12.setAttribute("Last-Modified", var22_33);
                    }
                }
                ServletCacheUtils.saveVars(var4_4, var12_12, this.vars, "request");
                if (this.key == null) {
                    var4_4.setCache(this.scope, var9_10, var12_12, var20_27);
                } else {
                    var4_4.setCache(this.scope, var9_10, this.size, var14_11, var12_12, var20_27);
                }
                break block53;
lbl101:
                // 1 sources

                if (CacheFilter.verbose) {
                    System.out.println("Cache exists for " + var9_10);
                }
                if (!var5_5) {
                    var16_16 = (String)var12_12.getAttribute("Content-Type");
                    if (var16_16 != null) {
                        var7_8.setHeader("Content-Type", (String)var16_16);
                    }
                    if ((var17_20 = (String)var12_12.getAttribute("Last-Modified")) != null) {
                        var7_8.setHeader("Last-Modified", var17_20);
                    }
                }
                ServletCacheUtils.restoreVars(var4_4, var12_12, this.vars, "request");
                if (var5_5 || (var16_16 = var6_7.getHeader("If-Modified-Since")) == null || !var16_16.equals(var12_12.getAttribute("Last-Modified"))) break block53;
                var7_8.setStatus(304);
                var1_1.removeAttribute("weblogic.cache.tag.CacheTag.caching");
                try {
                    var4_4.releaseAllLocks();
                }
                catch (CacheException var17_21) {
                    throw new ServletException("Cache may be corrupt", (Throwable)var17_21);
                }
                return;
            }
            if (var5_5 || !var6_7.getMethod().equals("HEAD")) break block54;
            var1_1.removeAttribute("weblogic.cache.tag.CacheTag.caching");
            try {
                var4_4.releaseAllLocks();
            }
            catch (CacheException var16_17) {
                throw new ServletException("Cache may be corrupt", (Throwable)var16_17);
            }
            return;
        }
        try {
            if ((var5_5 || var15_13 != 304) && (var13_32 = (byte[])var12_12.getContent()) != null && var13_32.length > 0) {
                var2_2.setContentLength(var13_32.length);
                try {
                    var2_2.getOutputStream().write(var13_32, 0, var13_32.length);
                }
                catch (IllegalStateException var16_18) {
                    var2_2.getWriter().write(new String(var13_32, var2_2.getCharacterEncoding()));
                }
            }
            {
                catch (CacheException var10_15) {
                    HTTPLogger.logNotCachingTheResponse((String)var6_7.getRequestURI(), (String)var10_15.getMessage());
                    var3_3.doFilter(var1_1, var2_2);
                }
            }
            if (CacheFilter.verbose) {
                System.out.println("Filter end");
            }
        }
        catch (Throwable var23_34) {
            throw var23_34;
        }
        finally {
            var1_1.removeAttribute("weblogic.cache.tag.CacheTag.caching");
            try {
                var4_4.releaseAllLocks();
            }
            catch (CacheException var5_6) {
                throw new ServletException("Cache may be corrupt", (Throwable)var5_6);
            }
        }
    }

    private ServletResponseImpl getOriginalResponse(HttpServletResponse httpServletResponse) {
        while (httpServletResponse instanceof ServletResponseWrapper) {
            ServletResponseWrapper servletResponseWrapper = (ServletResponseWrapper)httpServletResponse;
            httpServletResponse = (HttpServletResponse)servletResponseWrapper.getResponse();
        }
        if (httpServletResponse instanceof ServletResponseImpl) {
            return (ServletResponseImpl)httpServletResponse;
        }
        return null;
    }

    private static class CacheOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private ServletResponse res = null;
        private boolean isCaching = true;
        private long maxSize;
        private boolean useWriter = false;
        private CacheServletResponse csr;

        public CacheOutputStream(ServletResponse servletResponse, long l, CacheServletResponse cacheServletResponse) {
            this.res = servletResponse;
            this.isCaching = true;
            this.maxSize = l;
            this.csr = cacheServletResponse;
        }

        public byte[] getContent() {
            return this.baos.toByteArray();
        }

        public boolean isCaching() {
            return this.isCaching;
        }

        private void writeDirectly(int n) throws IOException {
            if (this.useWriter) {
                this.res.getWriter().write((char)n);
            } else {
                try {
                    this.res.getOutputStream().write(n);
                }
                catch (IllegalStateException illegalStateException) {
                    this.res.getWriter().write((char)n);
                    this.useWriter = true;
                }
            }
        }

        private void writeDirectly(byte[] byArray, int n, int n2) throws IOException {
            if (this.useWriter) {
                this.res.getWriter().write(new String(byArray, n, n2, this.res.getCharacterEncoding()));
            } else {
                try {
                    this.res.getOutputStream().write(byArray, n, n2);
                }
                catch (IllegalStateException illegalStateException) {
                    this.res.getWriter().write(new String(byArray, n, n2, this.res.getCharacterEncoding()));
                    this.useWriter = true;
                }
            }
        }

        public void write(int n) throws IOException {
            if (this.csr.largeCL() || !this.isCaching) {
                this.writeDirectly(n);
                return;
            }
            if ((long)this.baos.size() >= this.maxSize) {
                this.isCaching = false;
                byte[] byArray = this.baos.toByteArray();
                if (byArray != null && byArray.length > 0) {
                    this.writeDirectly(byArray, 0, byArray.length);
                }
                this.writeDirectly(n);
                return;
            }
            this.baos.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.csr.largeCL() || !this.isCaching) {
                this.writeDirectly(byArray, n, n2);
                return;
            }
            if ((long)(this.baos.size() + n2) > this.maxSize) {
                this.isCaching = false;
                byte[] byArray2 = this.baos.toByteArray();
                if (byArray2 != null && byArray2.length > 0) {
                    this.writeDirectly(byArray2, 0, byArray2.length);
                }
                this.writeDirectly(byArray, n, n2);
                return;
            }
            this.baos.write(byArray, n, n2);
        }
    }

    private static class CacheServletRequest
    extends HttpServletRequestWrapper {
        public CacheServletRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public String getHeader(String string) {
            if (string.equals("If-Modified-Since")) {
                return null;
            }
            return super.getHeader(string);
        }

        public long getDateHeader(String string) {
            if (string.equals("If-Modified-Since")) {
                return 0L;
            }
            return super.getDateHeader(string);
        }
    }

    private static class CacheServletResponse
    extends HttpServletResponseWrapper {
        private PrintWriter writer;
        private ServletOutputStream sos;
        private CacheOutputStream cos;
        private long maxSize;
        boolean largeCL = false;

        public CacheServletResponse(HttpServletResponse httpServletResponse, long l) throws IOException {
            super(httpServletResponse);
            this.maxSize = l;
            this.cos = new CacheOutputStream((ServletResponse)httpServletResponse, l, this);
        }

        public byte[] getContent() {
            return this.cos.getContent();
        }

        public boolean isCaching() {
            return this.cos.isCaching();
        }

        public boolean largeCL() {
            return this.largeCL;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("Cannot get Writer then OutputStream");
            }
            this.sos = this.cos;
            return this.sos;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.sos != null) {
                throw new IllegalStateException("Cannot get OutputStream then Writer");
            }
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.cos), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        public void setHeader(String string, String string2) {
            if (string.equalsIgnoreCase("Content-Length")) {
                this.setContentLength(Integer.parseInt(string2));
                return;
            }
            super.setHeader(string, string2);
        }

        public void addHeader(String string, String string2) {
            if (string.equalsIgnoreCase("Content-Length")) {
                this.setContentLength(Integer.parseInt(string2));
                return;
            }
            super.addHeader(string, string2);
        }

        public void setContentLength(int n) {
            if ((long)n > this.maxSize) {
                this.largeCL = true;
            }
            super.setContentLength(n);
        }

        public void flushBuffer() {
            block4: {
                try {
                    if (this.writer != null) {
                        this.writer.flush();
                    }
                    if (this.sos != null) {
                        this.sos.flush();
                    }
                }
                catch (IOException iOException) {
                    if (!verbose) break block4;
                    iOException.printStackTrace();
                }
            }
        }

        public void resetBuffer() {
            this.cos = new CacheOutputStream(this.getResponse(), this.maxSize, this);
            if (this.writer != null) {
                try {
                    this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.cos), this.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (this.sos != null) {
                this.sos = this.cos;
            }
        }
    }
}

