/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.lld;

import weblogic.cache.lld.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseCacheEntry<K, V>
implements CacheEntry<K, V> {
    protected final K key;
    protected V value;
    protected final long createTime;
    protected long lastAccessTime;
    protected long lastUpdateTime;
    protected long ttl;
    protected boolean discarded;

    public BaseCacheEntry(K k, V v) {
        this(k, v, -1L);
    }

    public BaseCacheEntry(K k, V v, long l) {
        this.key = k;
        this.value = v;
        this.lastUpdateTime = this.lastAccessTime = System.currentTimeMillis();
        this.createTime = this.lastAccessTime;
        this.ttl = l;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.value;
    }

    @Override
    public V setValue(V v) {
        this.lastUpdateTime = this.lastAccessTime = System.currentTimeMillis();
        V v2 = this.value;
        this.value = v;
        return v2;
    }

    @Override
    public long expiration() {
        return this.lastUpdateTime + this.ttl * 1000L;
    }

    public boolean expired() {
        if (this.ttl < 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.expiration();
    }

    @Override
    public long getCreationTime() {
        return this.createTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    @Override
    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public void discard() {
        this.discarded = true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof BaseCacheEntry)) {
            return false;
        }
        BaseCacheEntry baseCacheEntry = (BaseCacheEntry)object;
        return (this.key == null ? baseCacheEntry.getKey() == null : this.key.equals(baseCacheEntry.getKey())) && (this.value == null ? baseCacheEntry.getValue() == null : this.value.equals(baseCacheEntry.getValue()));
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return super.toString() + "|key:" + this.key.toString() + "|value:" + this.value.toString();
    }
}

