/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.lld;

import java.io.IOException;
import java.util.Map;
import weblogic.cache.lld.CacheEntry;
import weblogic.cache.lld.LLDGroupMessageInvalidator;
import weblogic.cache.lld.LLDLogger;
import weblogic.rmi.spi.HostID;

public class LDDGroupMessageUpdater
extends LLDGroupMessageInvalidator {
    private static final boolean VERBOSE = true;

    public LDDGroupMessageUpdater(String string, Map map) {
        super(string, map);
    }

    public void onUpdate(CacheEntry cacheEntry, Object object) {
        System.out.println("Sending update of: " + cacheEntry.getKey());
        this.sendPutMessage(cacheEntry.getKey(), cacheEntry.getValue());
    }

    public void onCreate(CacheEntry cacheEntry) {
        System.out.println("Sending create of: " + cacheEntry.getKey());
        this.sendPutMessage(cacheEntry.getKey(), cacheEntry.getValue());
    }

    private void sendPutMessage(Object object, Object object2) {
        try {
            PutMessage putMessage = new PutMessage(this.cacheName, object, object2);
            this.multicastSession.send(putMessage);
        }
        catch (IOException iOException) {
            LLDLogger.logMessageException((String)("" + object), (IOException)iOException);
        }
    }

    protected static class PutMessage
    extends LLDGroupMessageInvalidator.RemoveMessage {
        private final Object value;

        PutMessage(String string, Object object, Object object2) {
            super(string, object);
            this.value = object2;
        }

        public void execute(HostID hostID) {
            System.out.println("Putting entry: " + this.key);
            Map map = this.getLocalMap();
            System.out.println("got map: " + map);
            if (map == null) {
                return;
            }
            map.put(this.key, this.value);
        }
    }
}

