/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.lld;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import weblogic.cache.lld.CacheEntry;
import weblogic.cache.lld.ChangeListener;
import weblogic.cache.lld.LLDLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.rmi.spi.HostID;
import weblogic.utils.collections.WeakConcurrentHashMap;

public class LLDGroupMessageInvalidator
implements ChangeListener {
    private static final boolean VERBOSE = false;
    private static final WeakConcurrentHashMap caches = new WeakConcurrentHashMap();
    protected final String cacheName;
    protected final MulticastSession multicastSession;

    public LLDGroupMessageInvalidator(String string, Map map) {
        this.cacheName = string;
        caches.put((Object)this.cacheName, (Object)map);
        ClusterServices clusterServices = ClusterService.getServices();
        if (clusterServices == null) {
            throw new RuntimeException("This server is not in a cluster.");
        }
        this.multicastSession = clusterServices.createMulticastSession(new CacheStateRecoverListener(), -1, false);
    }

    public void onCreate(CacheEntry cacheEntry) {
    }

    public void onUpdate(CacheEntry cacheEntry, Object object) {
    }

    public void onDelete(CacheEntry cacheEntry) {
        try {
            RemoveMessage removeMessage = new RemoveMessage(this.cacheName, cacheEntry.getKey());
            this.multicastSession.send(removeMessage);
        }
        catch (IOException iOException) {
            LLDLogger.logMessageException((String)("" + cacheEntry.getKey()), (IOException)iOException);
        }
    }

    public void onClear() {
        try {
            ClearMessage clearMessage = new ClearMessage(this.cacheName);
            this.multicastSession.send(clearMessage);
        }
        catch (IOException iOException) {
            LLDLogger.logMessageException((String)"<all keys>", (IOException)iOException);
        }
    }

    protected class CacheStateRecoverListener
    implements RecoverListener {
        protected CacheStateRecoverListener() {
        }

        public GroupMessage createRecoverMessage() {
            return new ClearMessage(LLDGroupMessageInvalidator.this.cacheName);
        }
    }

    protected static class ClearMessage
    extends Message {
        ClearMessage(String string) {
            super(string);
        }

        public void execute(HostID hostID) {
            Map map = this.getLocalMap();
            if (map == null) {
                return;
            }
            map.clear();
        }
    }

    protected static class RemoveMessage
    extends Message {
        protected final Object key;

        RemoveMessage(String string, Object object) {
            super(string);
            this.key = object;
        }

        public void execute(HostID hostID) {
            Map map = this.getLocalMap();
            if (map == null) {
                return;
            }
            map.remove(this.key);
        }
    }

    protected static abstract class Message
    implements Serializable,
    GroupMessage {
        protected final String cacheName;

        protected Message(String string) {
            this.cacheName = string;
        }

        protected Map getLocalMap() {
            return (Map)caches.get((Object)this.cacheName);
        }

        public abstract void execute(HostID var1);
    }
}

