/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.tag;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import weblogic.cache.CacheException;
import weblogic.cache.CacheValue;
import weblogic.cache.KeyEnumerator;
import weblogic.cache.webapp.KeySet;
import weblogic.cache.webapp.ServletCacheUtils;
import weblogic.cache.webapp.WebAppCacheSystem;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.StackTraceUtils;

public class CacheTag
extends BodyTagSupport
implements TryCatchFinally {
    static final long serialVersionUID = 2706226325452664446L;
    private static boolean debug = false;
    private static boolean verbose = false;
    private int timeout = -1;
    private String timeoutString;
    private String scope = "application";
    private String name;
    private int size = -1;
    private String key;
    private boolean async = false;
    private String vars;
    private String flush;
    private boolean trigger;
    private static boolean initialized;
    private long startTime;
    private KeySet keySet;
    private WebAppCacheSystem cs = new WebAppCacheSystem();
    private CacheValue cache;
    private static boolean nestwarning;
    private CacheValue oldCache;
    private boolean failed;
    protected Map savedPageContextValues;
    private static final Object DELETE;
    private boolean cacheUpdate = false;
    private Map savedPageScope;
    private Map savedRequestScope;
    private Map savedSessionScope;
    private Map savedApplicationScope;
    private Map updatedPageScope;
    private Map updatedRequestScope;
    private Map updatedSessionScope;
    private Map updatedApplicationScope;

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public void setTimeout(String string) throws CacheException {
        this.timeout = ServletCacheUtils.getTimeout(string);
        if (debug) {
            System.out.println("Timeout: " + this.timeout);
        }
        this.timeoutString = string;
    }

    public String getTimeout() {
        return this.timeoutString;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setName(String string) {
        this.name = string.intern();
    }

    public String getName() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        if (this.name == null) {
            Integer n = (Integer)this.pageContext.getAttribute("weblogicx.cache.tag.CacheTag.instanceNum");
            int n2 = n == null ? 0 : n + 1;
            this.pageContext.setAttribute("weblogicx.cache.tag.CacheTag.instanceNum", (Object)new Integer(n2));
            Object object = httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            if (object == null) {
                object = httpServletRequest.getRequestURI();
            }
            this.name = ("weblogicx.cache.tag.CacheTag." + object + "." + n2).intern();
        }
        return this.name;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setAsync(boolean bl) {
        this.async = bl;
    }

    public boolean getAsync() {
        return this.async;
    }

    public void setVars(String string) {
        this.vars = string;
    }

    public String getVars() {
        return this.vars;
    }

    public void setFlush(String string) {
        this.flush = string;
    }

    public String getFlush() {
        return this.flush;
    }

    public void setTrigger(boolean bl) {
        this.trigger = bl;
    }

    public boolean getTrigger() {
        return this.trigger;
    }

    public int doStartTag() throws JspException {
        try {
            Object object;
            if (this.flush == null) {
                object = this.pageContext.getRequest();
                if (object.getAttribute("weblogic.cache.tag.CacheTag.caching") == null) {
                    object.setAttribute("weblogic.cache.tag.CacheTag.caching", (Object)"true");
                } else if (!nestwarning) {
                    this.pageContext.getServletContext().log("Nested cache tags have been detected.  Inner cache tags will only be updated when their containing tag is updated.");
                    nestwarning = true;
                }
            }
            this.cs.setPageContext(this.pageContext);
            object = ((HttpServletRequest)this.pageContext.getRequest()).getMethod();
            if (((String)object).equals("POST") || ((String)object).equals("PUT")) {
                this.async = false;
            }
            if (this.key == null) {
                return this.doStartCache();
            }
            return this.doStartKeyedCache();
        }
        catch (CacheException cacheException) {
            throw new JspException("We experienced an underlying cache exception during revert, cache may be corrupt: " + StackTraceUtils.throwable2StackTrace((Throwable)((Object)cacheException)));
        }
    }

    protected int doStartCache() throws CacheException, JspException {
        boolean bl;
        boolean bl2 = bl = "true".equals(this.flush) || "now".equals(this.flush);
        if (bl || this.trigger) {
            this.cs.flushCache(this.scope, this.getName());
            if (bl) {
                return 0;
            }
        }
        if (this.async) {
            this.oldCache = this.cs.getCurrentCache(this.scope, this.getName());
        }
        this.cache = this.cs.getCache(this.scope, this.getName());
        if (this.cache != null && "lazy".equals(this.flush)) {
            this.cache.setFlush(true);
            return 0;
        }
        if (this.cache == null) {
            if (this.async && this.oldCache != null) {
                this.asyncForward();
            }
            this.startTime = System.currentTimeMillis();
            this.cache = new CacheValue();
            this.pageContext.setAttribute(this.getName(), (Object)this.cache);
            return 2;
        }
        this.pageContext.setAttribute(this.getName(), (Object)this.cache);
        try {
            this.pageContext.getOut().print((String)this.cache.getContent());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.revertPageContextVariables();
        ServletCacheUtils.restoreVars(this.cs, this.cache, this.vars, "request");
        return 0;
    }

    protected int doEndCache() throws CacheException {
        this.cache.setContent(this.getBodyContent().getString());
        this.cache.setTimeout(this.timeout);
        ServletCacheUtils.saveVars(this.cs, this.cache, this.vars, "request");
        int n = (int)(System.currentTimeMillis() - this.startTime);
        this.cs.setCache(this.scope, this.getName(), this.cache, n);
        try {
            if (!this.cacheUpdate) {
                this.getBodyContent().getEnclosingWriter().print((String)this.cache.getContent());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    protected int doStartKeyedCache() throws CacheException, JspException {
        boolean bl;
        KeySet keySet = this.getKeySet();
        boolean bl2 = bl = "true".equals(this.flush) || "now".equals(this.flush);
        if (bl || this.trigger) {
            this.cs.flushCache(this.scope, this.getName(), keySet);
            if (bl) {
                return 0;
            }
        }
        if (this.async) {
            this.oldCache = this.cs.getCurrentCache(this.scope, this.getName(), this.size, keySet);
        }
        this.cache = this.cs.getCache(this.scope, this.getName(), this.size, keySet);
        if (this.cache != null && "lazy".equals(this.flush)) {
            this.cache.setFlush(true);
            return 0;
        }
        if (this.cache == null) {
            if (this.async && this.oldCache != null) {
                this.asyncForward();
            }
            this.startTime = System.currentTimeMillis();
            this.cache = new CacheValue();
            this.pageContext.setAttribute(this.getName(), (Object)this.cache);
            return 2;
        }
        this.pageContext.setAttribute(this.getName(), (Object)this.cache);
        try {
            if (!this.cacheUpdate) {
                this.pageContext.getOut().print((String)this.cache.getContent());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.revertPageContextVariables();
        ServletCacheUtils.restoreVars(this.cs, this.cache, this.vars, "request");
        return 0;
    }

    protected int doEndKeyedCache() throws CacheException {
        KeySet keySet = this.getKeySet();
        this.cache.setContent(this.getBodyContent().getString());
        this.cache.setTimeout(this.timeout);
        ServletCacheUtils.saveVars(this.cs, this.cache, this.vars, "request");
        int n = (int)(System.currentTimeMillis() - this.startTime);
        this.cs.setCache(this.scope, this.getName(), this.size, keySet, this.cache, n);
        try {
            this.getBodyContent().getEnclosingWriter().print((String)this.cache.getContent());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public int doEndTag() {
        if (this.cacheUpdate) {
            return 5;
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        if (this.failed) {
            return 0;
        }
        try {
            this.revertPageContextVariables();
            if (this.cacheUpdate) {
                this.revertKeysAfterCacheUpdate();
            }
            if (this.key == null) {
                return this.doEndCache();
            }
            return this.doEndKeyedCache();
        }
        catch (CacheException cacheException) {
            throw new JspException("We experienced an underlying cache exception during revert, cache may be corrupt: " + StackTraceUtils.throwable2StackTrace((Throwable)((Object)cacheException)));
        }
    }

    public void release() {
        try {
            this.cs.releaseAllLocks();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        this.timeout = -1;
        this.timeoutString = null;
        this.scope = "application";
        this.name = null;
        this.size = -1;
        this.key = null;
        this.vars = null;
        this.flush = null;
        this.keySet = null;
        this.savedPageContextValues = null;
        this.cache = null;
        this.cacheUpdate = false;
        this.savedPageScope = null;
        this.savedRequestScope = null;
        this.savedSessionScope = null;
        this.savedApplicationScope = null;
        this.updatedPageScope = null;
        this.updatedRequestScope = null;
        this.updatedSessionScope = null;
        this.updatedApplicationScope = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCatch(Throwable throwable) throws Throwable {
        block13: {
            this.pageContext.getServletContext().log("Cache " + this.getName() + " failed to refresh with an exception: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            CacheValue cacheValue = null;
            try {
                this.revertPageContextVariables();
                cacheValue = this.key == null ? this.cs.getCurrentCache(this.scope, this.getName()) : this.cs.getCurrentCache(this.scope, this.getName(), this.size, this.getKeySet());
                if (cacheValue != null) {
                    try {
                        this.pageContext.getOut().print(cacheValue.getContent());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ServletCacheUtils.restoreVars(this.cs, this.cache, this.vars, "request");
                    this.failed = true;
                    this.pageContext.setAttribute(this.getName(), (Object)cacheValue);
                    break block13;
                }
                this.pageContext.removeAttribute(this.getName());
                throw throwable;
            }
            finally {
                int n = (int)(System.currentTimeMillis() - this.startTime);
                try {
                    if (this.key == null) {
                        this.cs.setCache(this.scope, this.getName(), cacheValue, n);
                    } else {
                        this.cs.setCache(this.scope, this.getName(), this.size, this.keySet, cacheValue, n);
                    }
                }
                finally {
                    this.release();
                }
            }
        }
    }

    public void doFinally() {
        this.oldCache = null;
        this.failed = false;
        ServletRequest servletRequest = this.pageContext.getRequest();
        servletRequest.removeAttribute("weblogic.cache.tag.CacheTag.caching");
    }

    protected void revertPageContextVariables() {
        if (this.key != null && this.savedPageContextValues != null) {
            for (String string : this.savedPageContextValues.keySet()) {
                Object v = this.savedPageContextValues.get(string);
                if (v == DELETE) {
                    this.pageContext.removeAttribute(string, 1);
                    continue;
                }
                this.pageContext.setAttribute(string, v);
            }
        }
    }

    protected void saveKeysBeforeForward() throws CacheException, JspException {
        if (this.key == null) {
            return;
        }
        this.savedPageScope = new HashMap();
        this.savedRequestScope = new HashMap();
        this.savedSessionScope = new HashMap();
        this.savedApplicationScope = new HashMap();
        this.storeKeyValues(this.savedPageScope, this.savedRequestScope, this.savedSessionScope, this.savedApplicationScope);
    }

    protected void revertKeysAfterForward() throws JspException {
        if (this.key == null) {
            return;
        }
        this.revertValues(this.savedPageScope, this.savedRequestScope, this.savedSessionScope, this.savedApplicationScope);
    }

    protected void saveKeysBeforeCacheUpdate() throws CacheException, JspException {
        if (this.key == null) {
            return;
        }
        this.updatedPageScope = new HashMap();
        this.updatedRequestScope = new HashMap();
        this.updatedSessionScope = new HashMap();
        this.updatedApplicationScope = new HashMap();
        this.storeKeyValues(this.updatedPageScope, this.updatedRequestScope, this.updatedSessionScope, this.updatedApplicationScope);
    }

    protected void revertKeysAfterCacheUpdate() throws JspException {
        if (this.key == null) {
            return;
        }
        this.revertValues(this.updatedPageScope, this.updatedRequestScope, this.updatedSessionScope, this.updatedApplicationScope);
    }

    protected void storeKeyValues(Map map, Map map2, Map map3, Map map4) throws CacheException, JspException {
        KeyEnumerator keyEnumerator = new KeyEnumerator(this.key);
        while (keyEnumerator.hasMoreKeys()) {
            String string = keyEnumerator.getNextKey();
            String string2 = keyEnumerator.getKeyScope();
            Object object = this.cs.getValueFromScope(string2, string);
            if (string2.equals("any")) {
                if (this.pageContext.getRequest().getParameter(string) != null) continue;
                if (this.pageContext.getAttribute(string) != null) {
                    map.put(string, object);
                    continue;
                }
                if (this.pageContext.getRequest().getAttribute(string) != null) {
                    map2.put(string, object);
                    continue;
                }
                HttpSession httpSession = this.pageContext.getSession();
                if (httpSession != null && httpSession.getAttribute(string) != null) {
                    map3.put(string, object);
                    continue;
                }
                if (this.pageContext.getServletContext().getAttribute(string) == null) continue;
                map4.put(string, object);
                continue;
            }
            if (string2.equals("page")) {
                if (object == null) continue;
                map.put(string, object);
                continue;
            }
            if (string2.equals("request")) {
                if (object == null) continue;
                map2.put(string, object);
                continue;
            }
            if (string2.equals("session")) {
                if (object == null) continue;
                map3.put(string, object);
                continue;
            }
            if (!string2.equals("application") || object == null) continue;
            map4.put(string, object);
        }
    }

    protected void revertValues(Map map, Map map2, Map map3, Map map4) throws JspException {
        KeyEnumerator keyEnumerator = new KeyEnumerator(this.key);
        while (keyEnumerator.hasMoreKeys()) {
            Object object;
            Object object2;
            String string = keyEnumerator.getNextKey();
            String string2 = keyEnumerator.getKeyScope();
            if (string2.equals("any")) {
                object2 = map.get(string);
                if (object2 != null) {
                    this.pageContext.setAttribute(string, object2);
                    continue;
                }
                object2 = map2.get(string);
                if (object2 != null) {
                    this.pageContext.getRequest().setAttribute(string, object2);
                    continue;
                }
                object2 = map3.get(string);
                if (object2 != null) {
                    object = this.pageContext.getSession();
                    if (object == null) {
                        throw new JspException("Session scope specified but this page has no session");
                    }
                    object.setAttribute(string, object2);
                    continue;
                }
                object2 = map4.get(string);
                if (object2 != null) {
                    this.pageContext.getServletContext().setAttribute(string, object2);
                    continue;
                }
                if (this.pageContext.getRequest().getParameter(string) != null) continue;
                this.pageContext.removeAttribute(string);
                this.pageContext.getRequest().removeAttribute(string);
                object = this.pageContext.getSession();
                if (object != null) {
                    object.removeAttribute(string);
                }
                this.pageContext.getServletContext().removeAttribute(string);
                continue;
            }
            if (string2.equals("page")) {
                object2 = map.get(string);
                if (object2 == null) {
                    this.pageContext.removeAttribute(string);
                    continue;
                }
                this.pageContext.setAttribute(string, object2);
                continue;
            }
            if (string2.equals("request")) {
                object2 = map2.get(string);
                if (object2 == null) {
                    this.pageContext.getRequest().removeAttribute(string);
                    continue;
                }
                this.pageContext.getRequest().setAttribute(string, object2);
                continue;
            }
            if (string2.equals("session")) {
                object2 = this.pageContext.getSession();
                if (object2 == null) {
                    throw new JspException("Session scope specified but this page has no session");
                }
                object = map3.get(string);
                if (object == null) {
                    object2.removeAttribute(string);
                    continue;
                }
                object2.setAttribute(string, object);
                continue;
            }
            if (!string2.equals("application")) continue;
            object2 = map4.get(string);
            if (object2 == null) {
                this.pageContext.getServletContext().removeAttribute(string);
                continue;
            }
            this.pageContext.getServletContext().setAttribute(string, object2);
        }
    }

    protected void asyncForward() throws CacheException, JspException {
        try {
            this.saveKeysBeforeForward();
            if (verbose) {
                System.out.println("Forwarding request");
            }
            this.pageContext.forward(((HttpServletRequest)this.pageContext.getRequest()).getRequestURI().substring(((WebAppServletContext)this.pageContext.getServletContext()).getContextPath().length()));
            ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)this.pageContext.getResponse().getOutputStream();
            if (!this.pageContext.getResponse().isCommitted()) {
                ((HttpServletResponse)this.pageContext.getResponse()).setHeader("Content-Length", "" + servletOutputStreamImpl.getCount());
                servletOutputStreamImpl.flush();
            }
            this.saveKeysBeforeCacheUpdate();
            this.revertKeysAfterForward();
        }
        catch (IOException iOException) {
            throw new JspException("Could not asynchronously execute page: " + iOException);
        }
        catch (ServletException servletException) {
            throw new JspException("Could not asynchronously execute page: " + (Object)((Object)servletException));
        }
        this.cacheUpdate = true;
        this.startTime = System.currentTimeMillis();
        if (verbose) {
            System.out.println("Doing cache update");
        }
    }

    protected KeySet getKeySet() throws CacheException {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new KeySet(this.cs);
        KeyEnumerator keyEnumerator = new KeyEnumerator(this.key);
        while (keyEnumerator.hasMoreKeys()) {
            Object object;
            String string = keyEnumerator.getNextKey();
            String string2 = keyEnumerator.getKeyScope();
            Object object2 = this.keySet.addKey(string2, string);
            if (this.savedPageContextValues == null) {
                this.savedPageContextValues = new HashMap();
            }
            if ((object = this.pageContext.getAttribute(string)) != null) {
                this.savedPageContextValues.put(string, object);
            } else {
                this.savedPageContextValues.put(string, DELETE);
            }
            if (object2 == null) {
                this.pageContext.removeAttribute(string);
                continue;
            }
            this.pageContext.setAttribute(string, object2);
        }
        return this.keySet;
    }

    static {
        DELETE = new Object();
    }
}

