/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class BubblingCache
extends HashMap
implements Externalizable {
    static final long serialVersionUID = -7053192861279007995L;
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private ArrayList bubbler;
    private int maxSize;

    public BubblingCache() {
        this(100);
    }

    public BubblingCache(int n) {
        super(n);
        this.maxSize = n;
        this.bubbler = new ArrayList(n);
    }

    public synchronized Object get(Object object) {
        ValuePositionPair valuePositionPair = (ValuePositionPair)super.get(object);
        if (object == null) {
            throw new IllegalArgumentException("Cannot get key = null");
        }
        if (valuePositionPair == null) {
            return null;
        }
        if (valuePositionPair.position != 0) {
            Object e = this.bubbler.get(valuePositionPair.position - 1);
            ValuePositionPair valuePositionPair2 = (ValuePositionPair)super.get(e);
            valuePositionPair2.position = valuePositionPair.position--;
            this.bubbler.set(valuePositionPair2.position, e);
            this.bubbler.set(valuePositionPair.position, object);
        }
        return valuePositionPair.value;
    }

    public synchronized Object put(Object object, Object object2) {
        ValuePositionPair valuePositionPair = (ValuePositionPair)super.get(object);
        if (valuePositionPair != null) {
            Object object3 = valuePositionPair.value;
            valuePositionPair.value = object2;
            return object3;
        }
        int n = this.size();
        ValuePositionPair valuePositionPair2 = new ValuePositionPair();
        valuePositionPair2.value = object2;
        ValuePositionPair valuePositionPair3 = null;
        if (n == this.maxSize) {
            valuePositionPair2.position = n - 1;
            valuePositionPair3 = (ValuePositionPair)super.remove(this.bubbler.set(valuePositionPair2.position, object));
        } else {
            valuePositionPair2.position = n;
            this.bubbler.add(valuePositionPair2.position, object);
        }
        super.put(object, valuePositionPair2);
        return valuePositionPair3 == null ? null : valuePositionPair3.value;
    }

    public synchronized Object remove(Object object) {
        ValuePositionPair valuePositionPair = (ValuePositionPair)super.get(object);
        if (object == null) {
            throw new IllegalArgumentException("Cannot get key = null");
        }
        if (valuePositionPair == null) {
            return null;
        }
        Object v = super.remove(object);
        for (int i = valuePositionPair.position + 1; i < this.bubbler.size(); ++i) {
            Object e = this.bubbler.get(i);
            ValuePositionPair valuePositionPair2 = (ValuePositionPair)super.get(e);
            valuePositionPair2.position = i - 1;
            this.bubbler.set(i - 1, e);
        }
        int n = this.bubbler.size() - 1;
        this.bubbler.remove(n);
        valuePositionPair.position = -1;
        valuePositionPair.value = null;
        return v;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (String string : this.keySet()) {
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(super.get(string));
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.maxSize);
        objectOutput.writeInt(this.size());
        for (Object k : this.keySet()) {
            objectOutput.writeObject(k);
            objectOutput.writeObject(super.get(k));
        }
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this.maxSize = objectInput.readInt();
        int n2 = objectInput.readInt();
        this.bubbler = new ArrayList(this.maxSize);
        for (n = 0; n < n2; ++n) {
            this.bubbler.add("");
        }
        for (n = 0; n < n2; ++n) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            int n3 = ((ValuePositionPair)object2).position;
            this.bubbler.set(n3, object2);
            super.put(object, object2);
        }
    }

    private static class ValuePositionPair
    implements Serializable {
        public Object value;
        public int position;

        private ValuePositionPair() {
        }

        public String toString() {
            return "[ " + this.position + ": " + this.value + " ]";
        }
    }
}

