/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.utils;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.messaging.util.AbstractElement;
import weblogic.messaging.util.List;

public class ExpiredMap
extends AbstractElement
implements Map,
Cloneable {
    private List list;
    private Map map;
    private int maxCapacity;
    private long ttl;

    public ExpiredMap(int n, Map map, long l) {
        this.maxCapacity = n;
        this.ttl = l;
        this.map = map;
        this.list = new List();
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public synchronized boolean equals(Object object) {
        return ((Object)this.map).equals(object);
    }

    public synchronized int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public synchronized void putAll(Map map) {
        for (Object k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    public synchronized Object clone() {
        ExpiredMap expiredMap;
        try {
            expiredMap = (ExpiredMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        expiredMap.list = new List();
        expiredMap.map.clear();
        for (Node node = (Node)this.list.getFirst(); node != null; node = (Node)node.getNext()) {
            Node node2 = new Node(node.getKey(), node.getValue());
            expiredMap.list.add(node2);
            expiredMap.map.put(node.getKey(), node2);
            node2.setExpiration(node.getExpiration());
        }
        return expiredMap;
    }

    public synchronized void clear() {
        this.map.clear();
        this.list.clear();
    }

    private void evictExpiredOrOverMaxCapacity() {
        long l = System.currentTimeMillis();
        for (Node node = (Node)this.list.getFirst(); node != null && (node.getExpiration() <= l || this.list.size() > this.maxCapacity); node = (Node)node.getNext()) {
            Node node2 = node;
            this.evictOne(node2);
        }
    }

    private void evictOne(Node node) {
        assert (node.getList() == this.list);
        Node node2 = (Node)this.list.remove(node);
        assert (node2 == node);
        node2 = (Node)this.map.remove(node.getKey());
        assert (node2 == node);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean containsValue(Object var1_1) {
        var2_2 = System.currentTimeMillis();
        var5_3 = (Node)this.list.getFirst();
        block0: while (true) {
            if (var5_3 == null) {
                return false;
            }
            var4_4 = var5_3;
            var5_3 = (Node)var5_3.getNext();
            if (var4_4.getExpiration() < var2_2) {
                if (var4_4.getValue() == var1_1) {
                    this.list.remove(var4_4);
                    Node.access$300(var4_4);
                    this.evictExpiredOrOverMaxCapacity();
                    return true;
                }
                this.evictOne(var4_4);
                continue;
            }
            var5_3 = (Node)this.list.getLast();
            while (true) {
                if (var5_3 != null) ** break;
                continue block0;
                if (var4_4.getValue() == var1_1) {
                    this.list.remove(var4_4);
                    Node.access$300(var4_4);
                    return true;
                }
                var5_3 = (Node)var5_3.getPrev();
            }
            break;
        }
    }

    public synchronized Object get(Object object) {
        Node node = (Node)this.map.get(object);
        if (node == null) {
            this.evictExpiredOrOverMaxCapacity();
            return null;
        }
        this.list.remove(node);
        node.append();
        this.evictExpiredOrOverMaxCapacity();
        return node.getValue();
    }

    public synchronized Object put(Object object, Object object2) {
        Node node = (Node)this.map.remove(object);
        if (node == null) {
            node = new Node(object, object2);
            node.append();
            this.evictExpiredOrOverMaxCapacity();
            return this.map.put(object, node);
        }
        this.list.remove(node);
        node.append();
        this.evictExpiredOrOverMaxCapacity();
        return node.setValue(object2);
    }

    public synchronized Object putIfAbsent(Object object, Object object2) {
        Node node = (Node)this.map.get(object);
        if (node == null) {
            node = new Node(object, object2);
            node.append();
            this.evictExpiredOrOverMaxCapacity();
            return this.map.put(object, node);
        }
        this.list.remove(node);
        node.append();
        this.evictExpiredOrOverMaxCapacity();
        return node.getValue();
    }

    public synchronized Object remove(Object object) {
        Node node = (Node)this.map.remove(object);
        if (node == null) {
            this.evictExpiredOrOverMaxCapacity();
            return null;
        }
        this.list.remove(node);
        this.evictExpiredOrOverMaxCapacity();
        return node.getValue();
    }

    public synchronized Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new IteratorImpl(){

                    Object nextImpl(Node node) {
                        return node.getKey();
                    }
                };
            }

            public int size() {
                return ExpiredMap.this.size();
            }

            public boolean contains(Object object) {
                return ExpiredMap.this.containsValue(object);
            }
        };
    }

    public synchronized Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new IteratorImpl(){

                    Object nextImpl(Node node) {
                        return node.getValue();
                    }
                };
            }

            public int size() {
                return ExpiredMap.this.size();
            }

            public boolean contains(Object object) {
                return ExpiredMap.this.containsValue(object);
            }
        };
    }

    public synchronized Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new IteratorImpl(){

                    Object nextImpl(Node node) {
                        return node;
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean contains(Object object) {
                ExpiredMap expiredMap = ExpiredMap.this;
                synchronized (expiredMap) {
                    if (object instanceof Node && ExpiredMap.this.list.contains((Node)object)) {
                        return true;
                    }
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    Node node = (Node)ExpiredMap.this.map.get(entry.getKey());
                    return node != null && node.equals(entry);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean remove(Object object) {
                ExpiredMap expiredMap = ExpiredMap.this;
                synchronized (expiredMap) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Node node = (Node)ExpiredMap.this.map.remove(((Map.Entry)object).getKey());
                    if (node == null) {
                        return false;
                    }
                    ExpiredMap.this.list.remove(node);
                    return true;
                }
            }

            public int size() {
                return ExpiredMap.this.size();
            }

            public void clear0() {
                ExpiredMap.this.clear();
            }
        };
    }

    private abstract class IteratorImpl
    implements Iterator {
        private Node node;

        private IteratorImpl() {
            this.node = (Node)ExpiredMap.this.list.getFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ExpiredMap expiredMap = ExpiredMap.this;
            synchronized (expiredMap) {
                return this.node != null;
            }
        }

        abstract Object nextImpl(Node var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ExpiredMap expiredMap = ExpiredMap.this;
            synchronized (expiredMap) {
                Node node = this.node;
                if (node == null) {
                    throw new IllegalStateException("no next");
                }
                this.node = (Node)node.getNext();
                return this.nextImpl(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ExpiredMap expiredMap = ExpiredMap.this;
            synchronized (expiredMap) {
                Node node = this.node;
                if (node == null) {
                    throw new IllegalStateException("no next");
                }
                this.node = (Node)node.getNext();
                ExpiredMap.this.list.remove(node);
                ExpiredMap.this.map.remove(node.getKey());
            }
        }
    }

    private class Node
    extends AbstractElement
    implements Map.Entry {
        private final Object key;
        private Object value;
        private long expiration;

        private Node(Object object, Object object2) {
            this.key = object;
            this.value = object2;
            this.expiration = System.currentTimeMillis() + ExpiredMap.this.ttl;
        }

        private void append() {
            ExpiredMap.this.list.add(this);
            this.expiration = System.currentTimeMillis() + ExpiredMap.this.ttl;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long l) {
            this.expiration = l;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key == entry.getKey() || this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value == entry.getValue() || this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.toString() + " - key: " + this.key + " value: " + this.value;
        }
    }
}

