/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import weblogic.cache.webapp.CacheListener;
import weblogic.cache.webapp.KeySet;

public class CacheMonitor
implements CacheListener,
ServletContextListener {
    public static final String ATTRIBUTE = "weblogic.cache.CacheMonitor";
    private Node root = new Node();
    private static final int UPDATE = 1;
    private static final int ACCESS = 2;
    private static final int FLUSH = 3;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ArrayList<CacheMonitor> arrayList = (ArrayList<CacheMonitor>)servletContext.getAttribute("weblogic.cache.CacheListener");
        if (arrayList == null) {
            arrayList = new ArrayList<CacheMonitor>();
            servletContext.setAttribute("weblogic.cache.CacheListener", arrayList);
        }
        arrayList.add(this);
        servletContext.setAttribute(ATTRIBUTE, (Object)this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void cacheUpdateOccurred(CacheListener.CacheEvent cacheEvent) {
        this.update(1, cacheEvent);
    }

    public void cacheAccessOccurred(CacheListener.CacheEvent cacheEvent) {
        this.update(2, cacheEvent);
    }

    public void cacheFlushOccurred(CacheListener.CacheEvent cacheEvent) {
        this.update(3, cacheEvent);
    }

    private void update(int n, CacheListener.CacheEvent cacheEvent) {
        this.update(this.root, n, cacheEvent);
        String string = cacheEvent.getScopeType() + " " + cacheEvent.getScope();
        Node node = this.getSubNode(this.root, string);
        this.update(node, n, cacheEvent);
        String string2 = cacheEvent.getName();
        if (string2 == null) {
            return;
        }
        Node node2 = this.getSubNode(node, string2);
        this.update(node2, n, cacheEvent);
        KeySet keySet = cacheEvent.getKeySet();
        if (keySet == null) {
            return;
        }
        Node node3 = this.getSubNode(node2, keySet);
        this.update(node3, n, cacheEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Node node, int n, CacheListener.CacheEvent cacheEvent) {
        Node node2 = node;
        synchronized (node2) {
            switch (n) {
                case 1: {
                    node.updates++;
                    node.updateTime += cacheEvent.getTime();
                    break;
                }
                case 2: {
                    node.accesses++;
                    node.accessTime += cacheEvent.getTime();
                    break;
                }
                case 3: {
                    node.flushes++;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getSubNode(Node node, Object object) {
        Node node2;
        Node node3 = node;
        synchronized (node3) {
            node2 = node.getNode(object);
            if (node2 == null) {
                node2 = new Node();
                node.subMap.put(object, node2);
            }
        }
        return node2;
    }

    public Node getRoot() {
        return this.root;
    }

    public static class Node {
        private int updates;
        private int accesses;
        private int flushes;
        private int updateTime;
        private int accessTime;
        private Map subMap = new HashMap();

        public int getUpdates() {
            return this.updates;
        }

        public int getAccesses() {
            return this.accesses;
        }

        public int getFlushes() {
            return this.flushes;
        }

        public int getUpdateTime() {
            return this.updateTime;
        }

        public int getAccessTime() {
            return this.accessTime;
        }

        public synchronized Object[] getKeys() {
            return this.subMap.keySet().toArray();
        }

        public synchronized Node getNode(Object object) {
            return (Node)this.subMap.get(object);
        }
    }
}

