/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.cache.CacheException;
import weblogic.cache.CacheScope;
import weblogic.cache.CacheValue;
import weblogic.cache.RefWrapper;
import weblogic.cache.StallEvent;
import weblogic.cache.StallListener;
import weblogic.cache.utils.BubblingCache;
import weblogic.cache.webapp.CacheListener;
import weblogic.cache.webapp.KeySet;

public class CacheSystem {
    protected boolean verbose = false;
    protected boolean debug = false;
    protected List scopes;
    protected Map scopeMap;
    protected Set currentLocks;
    protected List listeners;
    protected boolean listening = true;
    protected int stallTime = 60000;
    protected List stallListeners = new ArrayList(1);

    public CacheSystem() {
        this.scopeMap = new HashMap();
        this.scopes = new ArrayList();
        this.currentLocks = new HashSet();
    }

    private List getListeners() {
        if (this.listeners == null) {
            try {
                Object object = this.getValueFromAnyScope("weblogic.cache.CacheListener");
                if (object instanceof List) {
                    this.listeners = (List)object;
                    this.listening = true;
                } else if (object != null) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(1);
                    arrayList.add(object);
                    this.listeners = arrayList;
                    this.listening = true;
                } else {
                    this.listeners = new ArrayList(0);
                    this.listening = false;
                }
            }
            catch (CacheException cacheException) {
                this.listeners = new ArrayList(0);
                this.listening = false;
            }
        }
        return this.listeners;
    }

    protected void sendCacheUpdateEvent(CacheListener.CacheEvent cacheEvent) {
        int n = this.getListeners().size();
        for (int i = 0; i < n; ++i) {
            ((CacheListener)this.listeners.get(i)).cacheUpdateOccurred(cacheEvent);
        }
    }

    protected void sendCacheAccessEvent(CacheListener.CacheEvent cacheEvent) {
        int n = this.getListeners().size();
        for (int i = 0; i < n; ++i) {
            ((CacheListener)this.listeners.get(i)).cacheAccessOccurred(cacheEvent);
        }
    }

    protected void sendCacheFlushEvent(CacheListener.CacheEvent cacheEvent) {
        int n = this.getListeners().size();
        for (int i = 0; i < n; ++i) {
            ((CacheListener)this.listeners.get(i)).cacheFlushOccurred(cacheEvent);
        }
    }

    public void setStallTime(int n) {
        this.stallTime = n;
    }

    public int getStallTime() {
        return this.stallTime;
    }

    public void addStallListener(StallListener stallListener) {
        this.stallListeners.add(stallListener);
    }

    public void removeStallListener(StallListener stallListener) {
        this.stallListeners.remove(stallListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheScope getScopeObject(String string) {
        Map map = this.scopeMap;
        synchronized (map) {
            return (CacheScope)this.scopeMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValueFromAnyScope(String string) throws CacheException {
        Map map = this.scopeMap;
        synchronized (map) {
            for (CacheScope cacheScope : this.scopes) {
                Object object = cacheScope.getAttribute(string);
                if (object == null) continue;
                return object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeLock(String string, String string2) throws CacheException {
        String string3 = string2 + ".lock";
        CacheScope cacheScope = this.getScopeObject(string);
        synchronized (cacheScope) {
            if (this.getValueFromScope(string, string3) != null) {
                if (this.verbose) {
                    System.out.println("Not acquired (" + string + "): " + string3);
                }
                return false;
            }
            Object object = new Object();
            this.setValueInScope(string, string3, object);
            this.currentLocks.add(new CacheLock(string, string2, object));
        }
        if (this.verbose) {
            System.out.println("Taken (" + string + "): " + string3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnLock(String string, String string2) throws CacheException {
        String string3 = string2 + ".lock";
        CacheScope cacheScope = this.getScopeObject(string);
        Object object = this.getValueFromScope(string, string3);
        if (object == null) {
            CacheScope cacheScope2 = cacheScope;
            synchronized (cacheScope2) {
                object = this.getValueFromScope(string, string3);
                if (object == null) {
                    Object object2 = new Object();
                    this.setValueInScope(string, string3, object2);
                    this.currentLocks.add(new CacheLock(string, string2, object2));
                    if (this.verbose) {
                        System.out.println("Taken (" + string + "): " + string3);
                    }
                    return;
                }
            }
        }
        while (object != null) {
            long l = System.currentTimeMillis();
            Object object3 = object;
            synchronized (object3) {
                try {
                    object.wait(this.stallTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((double)(System.currentTimeMillis() - l) > (double)this.stallTime * 0.99) {
                object3 = new StallEvent(this.stallTime, string, string2);
                for (StallListener stallListener : this.stallListeners) {
                    stallListener.stall((StallEvent)object3);
                }
            }
            if ((object = this.getValueFromScope(string, string3)) != null) continue;
            object3 = cacheScope;
            synchronized (object3) {
                object = this.getValueFromScope(string, string3);
                if (object != null) {
                    continue;
                }
                Object object4 = new Object();
                this.setValueInScope(string, string3, object4);
                this.currentLocks.add(new CacheLock(string, string2, object4));
                break;
            }
        }
        if (this.verbose) {
            System.out.println("Taken (" + string + "): " + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(String string, String string2) throws CacheException {
        CacheScope cacheScope;
        String string3 = string2 + ".lock";
        CacheScope cacheScope2 = cacheScope = this.getScopeObject(string);
        synchronized (cacheScope2) {
            Object object = this.getValueFromScope(string, string3);
            this.removeValueInScope(string, string3);
            this.currentLocks.remove(string2);
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        }
        if (this.verbose) {
            System.out.println("Released (" + string + "): " + string3);
        }
    }

    public void releaseAllLocks() throws CacheException {
        Iterator iterator = this.currentLocks.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            CacheLock cacheLock = (CacheLock)iterator.next();
            try {
                this.releaseLock(cacheLock.scope, cacheLock.key);
            }
            catch (CacheException cacheException) {
                bl = true;
            }
        }
        if (bl) {
            throw new CacheException("Could not release all locks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScope(String string, CacheScope cacheScope) {
        if (string == null) {
            throw new IllegalArgumentException("Name of scope cannot be null");
        }
        if (cacheScope == null) {
            throw new IllegalArgumentException("Scope cannot be null");
        }
        Map map = this.scopeMap;
        synchronized (map) {
            if (this.scopeMap.containsKey(string)) {
                throw new IllegalArgumentException("Scope already registered under " + string);
            }
            this.scopeMap.put(string, cacheScope);
            this.scopes.add(cacheScope);
        }
    }

    public CacheValue getCurrentCache(String string, String string2) throws CacheException {
        Object object = this.getValueFromScope(string, string2);
        if (object != null && !(object instanceof RefWrapper)) {
            System.out.println(object);
            throw new CacheException("You are using the same name for two caches that are not the same: " + string2);
        }
        RefWrapper refWrapper = (RefWrapper)object;
        CacheValue cacheValue = (CacheValue)(refWrapper == null ? null : refWrapper.get());
        return cacheValue;
    }

    public CacheValue getCache(String string, String string2) throws CacheException {
        long l = 0L;
        if (this.listening) {
            l = System.currentTimeMillis();
        }
        boolean bl = this.takeLock(string, string2);
        if ("true".equals(this.getValueFromAnyScope("_cache_refresh"))) {
            if (!bl) {
                this.waitOnLock(string, string2);
            }
            if (this.verbose) {
                System.out.println("_cache_refresh is active");
            }
            return null;
        }
        CacheValue cacheValue = this.getCurrentCache(string, string2);
        while (!bl && cacheValue == null) {
            this.waitOnLock(string, string2);
            bl = true;
            RefWrapper refWrapper = (RefWrapper)this.getValueFromScope(string, string2);
            cacheValue = (CacheValue)(refWrapper == null ? null : refWrapper.get());
        }
        if (!bl) {
            return cacheValue;
        }
        if (cacheValue != null) {
            int n = cacheValue.getTimeout();
            if (n != -1) {
                long l2 = cacheValue.getCreated();
                if (System.currentTimeMillis() - l2 > (long)n) {
                    if (this.verbose) {
                        System.out.println("Cache " + string + ":" + string2 + " timed out");
                    }
                    return null;
                }
            }
            if (cacheValue.getFlush()) {
                return null;
            }
        } else {
            if (this.verbose) {
                System.out.println("Cache " + string + ":" + string2 + " has nothing in it");
            }
            return null;
        }
        this.releaseLock(string, string2);
        if (this.verbose) {
            System.out.println("Returning contents of cache");
        }
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setTime((int)(System.currentTimeMillis() - l));
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            this.sendCacheAccessEvent(cacheEvent);
        }
        return cacheValue;
    }

    public void flushCache(String string, String string2) throws CacheException {
        this.removeValueInScope(string, string2);
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            this.sendCacheFlushEvent(cacheEvent);
        }
    }

    public void setCache(String string, String string2, CacheValue cacheValue, int n) throws CacheException {
        if (cacheValue == null) {
            this.removeValueInScope(string, string2);
        } else {
            if (cacheValue.getTimeout() != -1) {
                cacheValue.setCreated(System.currentTimeMillis());
            }
            if (this.verbose) {
                System.out.println("Cache " + string + ":" + string2 + " is now set");
            }
            this.setValueInScope(string, string2, new RefWrapper(cacheValue));
        }
        this.releaseLock(string, string2);
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setTime(n);
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            cacheEvent.setValue(cacheValue);
            this.sendCacheUpdateEvent(cacheEvent);
        }
    }

    public CacheValue getCurrentCache(String string, String string2, int n, KeySet keySet) throws CacheException {
        BubblingCache bubblingCache;
        String string3 = keySet.getKey();
        this.waitOnLock(string, string2);
        try {
            bubblingCache = (BubblingCache)this.getValueFromScope(string, string2);
        }
        catch (ClassCastException classCastException) {
            bubblingCache = null;
        }
        if (bubblingCache == null) {
            bubblingCache = n == -1 ? Collections.synchronizedMap(new HashMap()) : new BubblingCache(n);
            this.setValueInScope(string, string2, bubblingCache);
        }
        this.releaseLock(string, string2);
        RefWrapper refWrapper = (RefWrapper)bubblingCache.get(string3);
        CacheValue cacheValue = (CacheValue)(refWrapper == null ? null : refWrapper.get());
        return cacheValue;
    }

    public CacheValue getCache(String string, String string2, int n, KeySet keySet) throws CacheException {
        String string3 = keySet.getKey();
        long l = 0L;
        if (this.listening) {
            l = System.currentTimeMillis();
        }
        String string4 = string2 + '\u0000' + string3;
        boolean bl = this.takeLock(string, string4);
        if ("true".equals(this.getValueFromAnyScope("_cache_refresh"))) {
            if (!bl) {
                this.waitOnLock(string, string4);
            }
            return null;
        }
        CacheValue cacheValue = this.getCurrentCache(string, string2, n, keySet);
        while (!bl && cacheValue == null) {
            this.waitOnLock(string, string4);
            bl = true;
            cacheValue = this.getCurrentCache(string, string2, n, keySet);
        }
        if (!bl) {
            return cacheValue;
        }
        if (cacheValue != null) {
            int n2 = cacheValue.getTimeout();
            if (n2 != -1) {
                long l2 = cacheValue.getCreated();
                if (System.currentTimeMillis() - l2 > (long)n2) {
                    return null;
                }
            }
            if (cacheValue.getFlush()) {
                return null;
            }
        } else {
            return null;
        }
        this.releaseLock(string, string4);
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setTime((int)(System.currentTimeMillis() - l));
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            cacheEvent.setKeySet(keySet);
            this.sendCacheAccessEvent(cacheEvent);
        }
        return cacheValue;
    }

    public void setCache(String string, String string2, int n, KeySet keySet, CacheValue cacheValue, int n2) throws CacheException {
        BubblingCache bubblingCache;
        if (n == 0 || n < -1) {
            throw new CacheException("Invalid value for cache size: " + n);
        }
        String string3 = keySet.getKey();
        this.waitOnLock(string, string2);
        try {
            bubblingCache = (BubblingCache)this.getValueFromScope(string, string2);
        }
        catch (ClassCastException classCastException) {
            bubblingCache = null;
        }
        if (bubblingCache == null) {
            bubblingCache = n == -1 ? Collections.synchronizedMap(new HashMap()) : new BubblingCache(n);
            this.setValueInScope(string, string2, bubblingCache);
        }
        if (cacheValue == null) {
            bubblingCache.remove(string3);
        } else {
            if (cacheValue.getTimeout() != -1) {
                cacheValue.setCreated(System.currentTimeMillis());
            }
            bubblingCache.put(string3, new RefWrapper(cacheValue));
        }
        this.setValueInScope(string, string2, bubblingCache);
        this.releaseLock(string, string2);
        String string4 = string2 + '\u0000' + string3;
        this.releaseLock(string, string4);
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setTime(n2);
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            cacheEvent.setKeySet(keySet);
            cacheEvent.setValue(cacheValue);
            cacheEvent.setSize(n);
            this.sendCacheUpdateEvent(cacheEvent);
        }
    }

    public void flushCache(String string, String string2, KeySet keySet) throws CacheException {
        Map map;
        String string3 = keySet.getKey();
        this.waitOnLock(string, string2);
        try {
            map = (Map)this.getValueFromScope(string, string2);
        }
        catch (ClassCastException classCastException) {
            map = null;
        }
        if (map == null) {
            return;
        }
        this.releaseLock(string, string2);
        map.remove(string3);
        if (this.listening) {
            CacheListener.CacheEvent cacheEvent = new CacheListener.CacheEvent();
            cacheEvent.setScope(string);
            cacheEvent.setScopeType(this.getScopeObject(string).getClass().getName());
            cacheEvent.setName(string2);
            cacheEvent.setKeySet(keySet);
            this.sendCacheFlushEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueFromScope(String string, String string2) throws CacheException {
        CacheScope cacheScope;
        if (string.equals("any")) {
            return this.getValueFromAnyScope(string2);
        }
        Map map = this.scopeMap;
        synchronized (map) {
            cacheScope = (CacheScope)this.scopeMap.get(string);
        }
        if (cacheScope == null) {
            throw new CacheException("Could not find cache scope: " + string);
        }
        return cacheScope.getAttribute(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueInScope(String string, String string2, Object object) throws CacheException {
        CacheScope cacheScope;
        Map map = this.scopeMap;
        synchronized (map) {
            cacheScope = (CacheScope)this.scopeMap.get(string);
        }
        if (cacheScope == null) {
            throw new CacheException("Could not find cache scope: " + string);
        }
        cacheScope.setAttribute(string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueInScope(String string, String string2) throws CacheException {
        CacheScope cacheScope;
        Map map = this.scopeMap;
        synchronized (map) {
            cacheScope = (CacheScope)this.scopeMap.get(string);
        }
        if (cacheScope == null) {
            throw new CacheException("Could not find cache scope: " + string);
        }
        cacheScope.removeAttribute(string2);
    }

    class CacheLock {
        String key;
        String scope;
        Object lock;

        CacheLock(String string, String string2, Object object) {
            this.scope = string;
            this.key = string2;
            this.lock = object;
        }

        public int hashCode() {
            if (this.key == null) {
                return 0;
            }
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return this.key == ((CacheLock)object).key;
        }
    }
}

