/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import weblogic.cache.webapp.CacheListener;
import weblogic.cache.webapp.CacheMessage;
import weblogic.cache.webapp.ServletCacheUtils;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.MulticastSession;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;

public class ClusterListener
implements CacheListener,
ServletContextListener {
    private MulticastSession multicastSession;
    private ServletContext sc;
    private String httpServerName;
    private String contextName;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.sc = servletContextEvent.getServletContext();
        WebAppServletContext webAppServletContext = (WebAppServletContext)this.sc;
        this.httpServerName = webAppServletContext.getServer() == WebService.defaultHttpServer() ? null : webAppServletContext.getServer().getName();
        this.contextName = webAppServletContext.getContextPath();
        try {
            ClusterServices clusterServices = ClusterService.getServices();
            if (clusterServices == null) {
                this.sc.log("This server is not in a cluster.  Cluster caching disabled");
                return;
            }
            this.sc.log("Cluster caching enabled");
            this.multicastSession = clusterServices.createMulticastSession(null, -1);
            ServletCacheUtils.addCacheListener(this.sc, this);
        }
        catch (Exception exception) {
            this.sc.log("Could not register", (Throwable)exception);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletCacheUtils.removeCacheListener(this.sc, this);
    }

    public void cacheUpdateOccurred(CacheListener.CacheEvent cacheEvent) {
        if (cacheEvent.getScope().equals("cluster")) {
            try {
                CacheMessage cacheMessage = new CacheMessage(this.httpServerName, this.contextName, cacheEvent);
                this.multicastSession.send(cacheMessage);
            }
            catch (IOException iOException) {
                this.sc.log("Could not send cache message", (Throwable)iOException);
            }
        }
    }

    public void cacheFlushOccurred(CacheListener.CacheEvent cacheEvent) {
        this.cacheUpdateOccurred(cacheEvent);
    }

    public void cacheAccessOccurred(CacheListener.CacheEvent cacheEvent) {
    }
}

