/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.io.Serializable;
import java.util.NoSuchElementException;
import weblogic.cache.CacheException;
import weblogic.cache.webapp.CacheSystem;

public class KeySet
implements Serializable,
Comparable {
    private transient CacheSystem cs;
    private transient StringBuffer sb = new StringBuffer();
    private String key;
    public static final char KEY_SEPARATOR = '\u0000';

    public KeySet(CacheSystem cacheSystem) {
        this.cs = cacheSystem;
    }

    public Object addKey(String string, String string2) throws CacheException {
        if (this.cs == null) {
            throw new CacheException("You cannot add more keys once you have called getKey()");
        }
        try {
            Object object = this.cs.getValueFromScope(string, string2);
            this.sb.append('\u0000');
            this.sb.append(object == null ? "" : object.toString());
            return object;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new CacheException("Invalid key/keyScope attribute, key = " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey() {
        try {
            String string = this.key == null ? (this.key = this.sb.toString()) : this.key;
            return string;
        }
        finally {
            this.cs = null;
            this.sb = null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof KeySet) {
            KeySet keySet = (KeySet)object;
            return keySet.getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public int compareTo(Object object) {
        if (object instanceof KeySet) {
            KeySet keySet = (KeySet)object;
            return this.getKey().compareTo(keySet.getKey());
        }
        return -1;
    }
}

