/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletContext;
import weblogic.cache.CacheException;
import weblogic.cache.CacheValue;
import weblogic.cache.KeyEnumerator;
import weblogic.cache.webapp.CacheListener;
import weblogic.cache.webapp.CacheSystem;

public class ServletCacheUtils {
    public static final String CACHING = "weblogic.cache.tag.CacheTag.caching";

    public static void removeCacheListener(ServletContext servletContext, CacheListener cacheListener) {
        List list = (List)servletContext.getAttribute("weblogic.cache.CacheListener");
        if (list == null) {
            return;
        }
        list.remove(cacheListener);
    }

    public static void addCacheListener(ServletContext servletContext, CacheListener cacheListener) {
        ArrayList<CacheListener> arrayList = (ArrayList<CacheListener>)servletContext.getAttribute("weblogic.cache.CacheListener");
        if (arrayList == null) {
            arrayList = new ArrayList<CacheListener>();
            servletContext.setAttribute("weblogic.cache.CacheListener", arrayList);
        }
        if (!arrayList.contains(cacheListener)) {
            arrayList.add(cacheListener);
        }
    }

    public static int getTimeout(String string) throws CacheException {
        int n;
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n == 0) {
            return -1;
        }
        int n3 = Integer.parseInt(string.substring(0, n));
        String string2 = string.substring(n);
        if (string2.equals("s") || string2.equals("")) {
            return 1000 * n3;
        }
        if (string2.equals("ms")) {
            return n3;
        }
        if (string2.equals("h")) {
            return n3 * 1000 * 3600;
        }
        if (string2.equals("m")) {
            return n3 * 1000 * 60;
        }
        if (string2.equals("d")) {
            return n3 * 1000 * 3600 * 24;
        }
        throw new CacheException("Invalid time unit: " + string2 + " in " + string);
    }

    public static void saveVars(CacheSystem cacheSystem, CacheValue cacheValue, String string, String string2) throws CacheException {
        if (string == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        KeyEnumerator keyEnumerator = new KeyEnumerator(string);
        while (keyEnumerator.hasMoreKeys()) {
            String string3 = keyEnumerator.getNextKey();
            String string4 = keyEnumerator.getKeyScope();
            Object object = cacheSystem.getValueFromScope(string4, string3);
            if (object != null) {
                cacheSystem.setValueInScope(string2, string3, object);
                hashtable.put(string3, object);
                continue;
            }
            cacheSystem.removeValueInScope(string2, string3);
        }
        cacheValue.setVariables(hashtable);
    }

    public static void restoreVars(CacheSystem cacheSystem, CacheValue cacheValue, String string, String string2) throws CacheException {
        if (string == null) {
            return;
        }
        Hashtable hashtable = cacheValue.getVariables();
        if (hashtable == null) {
            throw new CacheException("Variable not present, probably an inconsistent cache state");
        }
        KeyEnumerator keyEnumerator = new KeyEnumerator(string);
        while (keyEnumerator.hasMoreKeys()) {
            Object v;
            String string3 = keyEnumerator.getNextKey();
            String string4 = keyEnumerator.getKeyScope();
            if (string4.equals("any")) {
                string4 = string2;
            }
            if ((v = hashtable.get(string3)) == null) {
                cacheSystem.removeValueInScope(string4, string3);
                cacheSystem.removeValueInScope(string2, string3);
                continue;
            }
            cacheSystem.setValueInScope(string4, string3, v);
            cacheSystem.setValueInScope(string2, string3, v);
        }
    }
}

