/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import weblogic.cache.CacheException;
import weblogic.cache.CacheScope;

public class ServletRequestCookieScope
implements CacheScope {
    private Map cookies = new HashMap();

    public ServletRequestCookieScope() {
    }

    public ServletRequestCookieScope(HttpServletRequest httpServletRequest) {
        this.setRequest(httpServletRequest);
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
            this.cookies.put(cookieArray[i].getName(), cookieArray[i].getValue());
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public Iterator getAttributeNames() throws CacheException {
        return this.cookies.keySet().iterator();
    }

    public void setAttribute(String string, Object object) throws CacheException {
        throw new CacheException("Servlet request cookie scope is read only, cannot write " + string + " = " + object);
    }

    public Object getAttribute(String string) throws CacheException {
        return this.cookies.get(string);
    }

    public void removeAttribute(String string) throws CacheException {
        throw new CacheException("Servlet request cookie scope is read only, cannot remove " + string);
    }
}

