/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.util.Iterator;
import javax.servlet.http.HttpSession;
import weblogic.cache.CacheException;
import weblogic.cache.CacheScope;
import weblogic.cache.EmptyIterator;
import weblogic.cache.EnumerationIterator;
import weblogic.servlet.internal.session.SessionInternal;

public class ServletSessionAttributeScope
implements CacheScope {
    private SessionInternal session;

    public ServletSessionAttributeScope() {
    }

    public ServletSessionAttributeScope(HttpSession httpSession) {
        this.session = (SessionInternal)httpSession;
    }

    public void setSession(HttpSession httpSession) {
        this.session = (SessionInternal)httpSession;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Iterator getAttributeNames() throws CacheException {
        if (this.session == null) {
            return new EmptyIterator();
        }
        return new EnumerationIterator(this.session.getInternalAttributeNames());
    }

    public void setAttribute(String string, Object object) throws CacheException {
        if (this.session == null) {
            throw new CacheException("Tried to set a value in a null session scope");
        }
        this.session.setInternalAttribute(string, object);
    }

    public Object getAttribute(String string) throws CacheException {
        if (this.session == null) {
            return null;
        }
        return this.session.getInternalAttribute(string);
    }

    public void removeAttribute(String string) throws CacheException {
        if (this.session == null) {
            return;
        }
        this.session.removeInternalAttribute(string);
    }
}

