/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import weblogic.cache.webapp.CacheSystem;
import weblogic.cache.webapp.ServletContextAttributeScope;
import weblogic.cache.webapp.ServletRequestAttributeScope;
import weblogic.cache.webapp.ServletRequestCookieScope;
import weblogic.cache.webapp.ServletRequestHeaderScope;
import weblogic.cache.webapp.ServletRequestParameterScope;
import weblogic.cache.webapp.ServletResponseHeaderScope;
import weblogic.cache.webapp.ServletSessionAttributeScope;
import weblogic.cache.webapp.WebAppFileScope;
import weblogic.servlet.internal.ServletResponseImpl;

public class WebAppCacheSystem
extends CacheSystem {
    private ServletRequestParameterScope srps = new ServletRequestParameterScope();
    private ServletRequestAttributeScope sras;
    private ServletRequestCookieScope srcs;
    private ServletSessionAttributeScope ssas;
    private static ServletContextAttributeScope scas = new ServletContextAttributeScope();
    private ServletRequestHeaderScope sqhs;
    private ServletResponseHeaderScope sshs;
    private WebAppFileScope wafs;

    public WebAppCacheSystem() {
        this.registerScope("parameter", this.srps);
        this.sras = new ServletRequestAttributeScope();
        this.registerScope("request", this.sras);
        this.srcs = new ServletRequestCookieScope();
        this.registerScope("cookie", this.srcs);
        this.sqhs = new ServletRequestHeaderScope();
        this.registerScope("requestHeader", this.sqhs);
        this.sshs = new ServletResponseHeaderScope();
        this.registerScope("responseHeader", this.sshs);
        this.ssas = new ServletSessionAttributeScope();
        this.registerScope("session", this.ssas);
        this.registerScope("application", scas);
        this.wafs = new WebAppFileScope();
        this.registerScope("file", this.wafs);
        this.registerScope("cluster", scas);
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this.srps.setRequest((ServletRequest)httpServletRequest);
        this.sras.setRequest((ServletRequest)httpServletRequest);
        this.srcs.setRequest(httpServletRequest);
        this.sqhs.setRequest(httpServletRequest);
        this.setSession(httpServletRequest.getSession(false));
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof ServletResponseImpl) {
            ServletResponseImpl servletResponseImpl = (ServletResponseImpl)httpServletResponse;
            this.sshs.setResponse(servletResponseImpl);
        }
    }

    public void setPageContext(PageContext pageContext) {
        this.setRequest((HttpServletRequest)pageContext.getRequest());
        this.setResponse((HttpServletResponse)pageContext.getResponse());
        this.setContext(pageContext.getServletContext());
    }

    public void setSession(HttpSession httpSession) {
        this.ssas.setSession(httpSession);
    }

    public void setContext(ServletContext servletContext) {
        scas.setContext(servletContext);
        this.wafs.setContext(servletContext);
    }
}

