/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cache.webapp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import weblogic.cache.CacheException;
import weblogic.cache.webapp.ServletContextAttributeScope;
import weblogic.management.DeploymentException;
import weblogic.persist.TxIndexedFile;
import weblogic.persist.TxIndexedFileStub;
import weblogic.servlet.WebLogicServletContext;

public class WebAppFileScope
extends ServletContextAttributeScope {
    private static final Map caches = new HashMap();
    private TxIndexedFile file;
    private boolean inited;

    public WebAppFileScope() {
    }

    public WebAppFileScope(ServletContext servletContext) {
        super(servletContext);
    }

    public void setAttribute(String string, Object object) throws CacheException {
        this.init();
        if (string.endsWith(".lock")) {
            super.setAttribute("filescope-" + string, object);
        } else {
            try {
                this.file.store(string, object);
            }
            catch (IOException iOException) {
                throw new CacheException("Could not write to file store", iOException);
            }
        }
    }

    public Object getAttribute(String string) throws CacheException {
        this.init();
        if (string.endsWith(".lock")) {
            return super.getAttribute("filescope-" + string);
        }
        return this.file.retrieve(string);
    }

    public void removeAttribute(String string) throws CacheException {
        this.init();
        if (string.endsWith(".lock")) {
            super.removeAttribute("filescope-" + string);
        } else {
            try {
                this.file.store(string, null);
            }
            catch (IOException iOException) {
                throw new CacheException("Could not write to file store", iOException);
            }
        }
    }

    public Iterator getAttributeNames() throws CacheException {
        this.init();
        final Enumeration enumeration = this.file.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        final Iterator iterator = super.getAttributeNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("filescope-") || !string.endsWith(".lock")) continue;
            arrayList.add(string);
        }
        iterator = arrayList.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements() || iterator.hasNext();
            }

            public Object next() {
                if (enumeration.hasMoreElements()) {
                    return enumeration.nextElement();
                }
                return iterator.next();
            }

            public void remove() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws CacheException {
        Class<WebAppFileScope> clazz = WebAppFileScope.class;
        synchronized (WebAppFileScope.class) {
            if (!this.inited) {
                if (this.file != null) {
                    this.file.shutdown();
                }
                File file = (File)this.getContext().getAttribute("javax.servlet.context.tempdir");
                String string = file.getAbsolutePath();
                this.file = (TxIndexedFile)caches.get(string);
                if (this.file == null) {
                    try {
                        this.file = new TxIndexedFileStub("cache", string, string);
                        caches.put(string, this.file);
                        this.registerContextListener();
                    }
                    catch (NamingException namingException) {
                        throw new CacheException("Could not create file store", namingException);
                    }
                }
                this.inited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void registerContextListener() throws CacheException {
        ServletContext servletContext = this.getContext();
        if (servletContext != null && servletContext instanceof WebLogicServletContext) {
            try {
                ((WebLogicServletContext)servletContext).registerListener(TxFileStubWiper.class.getName());
            }
            catch (DeploymentException deploymentException) {
                throw new CacheException(deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            catch (Exception exception) {
                throw new CacheException(exception.getMessage(), exception);
            }
        }
    }

    public static class TxFileStubWiper
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent servletContextEvent) {
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            ServletContext servletContext = servletContextEvent.getServletContext();
            if (servletContext == null) {
                return;
            }
            File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (file == null) {
                return;
            }
            String string = file.getAbsolutePath();
            Object v = caches.get(string);
            if (v == null || !(v instanceof TxIndexedFileStub)) {
                return;
            }
            ((TxIndexedFileStub)v).shutdown();
            caches.remove(string);
        }
    }
}

