/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider;

import weblogic.application.ApplicationFactoryManager;
import weblogic.cacheprovider.coherence.CoherenceClusterManager;
import weblogic.cacheprovider.coherence.CoherenceClusterSystemResourceDeploymentFactory;
import weblogic.cacheprovider.coherence.CoherenceException;
import weblogic.cacheprovider.coherence.application.CoherenceApplicationDeploymentExtensionFactory;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class CacheProviderServerService
extends AbstractServerService {
    public void start() throws ServiceFailureException {
        this.initialize();
    }

    private void initialize() throws ServiceFailureException {
        this.initFactories();
        this.initCoherence();
    }

    private void initFactories() {
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        applicationFactoryManager.addDeploymentFactory(new CoherenceClusterSystemResourceDeploymentFactory());
        applicationFactoryManager.addAppDeploymentExtensionFactory(new CoherenceApplicationDeploymentExtensionFactory());
    }

    private void initCoherence() throws ServiceFailureException {
        CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean;
        ClassLoader classLoader;
        CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
        if (coherenceClusterManager.isCoherenceAvailable(classLoader = Thread.currentThread().getContextClassLoader()) && (coherenceClusterSystemResourceMBean = CoherenceClusterManager.getServerMBean().getCoherenceClusterSystemResource()) != null) {
            try {
                coherenceClusterManager.configureClusterService(classLoader, coherenceClusterSystemResourceMBean.getName());
            }
            catch (CoherenceException coherenceException) {
                throw new ServiceFailureException(coherenceException.getMessage(), (Throwable)coherenceException);
            }
        }
    }
}

