/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider.coherence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ModuleException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.coherence.descriptor.wl.WeblogicCoherenceBean;
import weblogic.descriptor.DescriptorManager;

public class CoherenceClusterDescriptorHelper {
    public static WeblogicCoherenceBean createCoherenceDescriptor(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) throws ModuleException {
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = CoherenceClusterDescriptorHelper.createDescriptorLoader(inputStream, descriptorManager, list, bl);
        try {
            return CoherenceClusterDescriptorHelper.getCoherenceBean(abstractDescriptorLoader2);
        }
        catch (Exception exception) {
            throw new ModuleException("Could not create the Coherence Cluster descriptor", exception);
        }
    }

    public static WeblogicCoherenceBean createCoherenceDescriptor(String string) throws ModuleException {
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            AbstractDescriptorLoader2 abstractDescriptorLoader2 = CoherenceClusterDescriptorHelper.createDescriptorLoader(fileInputStream, null, null, true);
            WeblogicCoherenceBean weblogicCoherenceBean = CoherenceClusterDescriptorHelper.getCoherenceBean(abstractDescriptorLoader2);
            return weblogicCoherenceBean;
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static WeblogicCoherenceBean getCoherenceBean(AbstractDescriptorLoader2 abstractDescriptorLoader2) throws IOException, XMLStreamException {
        return (WeblogicCoherenceBean)abstractDescriptorLoader2.loadDescriptorBean();
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) {
        return new AbstractDescriptorLoader2(inputStream, descriptorManager, list, bl){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return CoherenceClusterDescriptorHelper.createVersionMunger(inputStream, this);
            }
        };
    }

    private static VersionMunger createVersionMunger(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        String string = "weblogic.coherence.descriptor.wl.WeblogicCoherenceBeanImpl$SchemaHelper2";
        return new VersionMunger(inputStream, abstractDescriptorLoader2, string, "http://xmlns.oracle.com/weblogic/weblogic-coherence");
    }
}

