/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider.coherence;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import weblogic.cacheprovider.coherence.CoherenceException;
import weblogic.cacheprovider.coherence.DebugLogger;
import weblogic.cacheprovider.coherence.management.CoherenceJMXBridge;
import weblogic.coherence.descriptor.wl.WeblogicCoherenceBean;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class CoherenceClusterManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private CoherenceJMXBridge jmxBridge = new CoherenceJMXBridge();

    public static CoherenceClusterManager getInstance() {
        return SingletonMaker.singleton;
    }

    private CoherenceClusterManager() {
    }

    public boolean isCoherenceAvailable(ClassLoader classLoader) {
        try {
            Object object = this.getWLSCoherenceConfigurator(classLoader);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void configureClusterService(ClassLoader classLoader, String string) throws CoherenceException {
        try {
            Object object;
            WeblogicCoherenceBean weblogicCoherenceBean = null;
            boolean bl = false;
            CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean = this.lookupCoherenceClusterSystemResourceMBean(string);
            if (coherenceClusterSystemResourceMBean != null) {
                weblogicCoherenceBean = coherenceClusterSystemResourceMBean.getCoherenceClusterResource();
                bl = coherenceClusterSystemResourceMBean.isUsingCustomClusterConfigurationFile();
            }
            if ((object = this.getWLSCoherenceConfigurator(classLoader)) != null) {
                Class<?> clazz = object.getClass();
                Class[] classArray = new Class[]{Boolean.TYPE, WeblogicCoherenceBean.class, String.class, String.class};
                Method method = clazz.getDeclaredMethod("configureClusterService", classArray);
                Object[] objectArray = new Object[]{bl, weblogicCoherenceBean, DomainDir.getConfigDir(), this.getLoggingDestination()};
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownClusterService(ClassLoader classLoader) throws CoherenceException {
        try {
            block4: {
                try {
                    Object object = this.getWLSCoherenceConfigurator(classLoader);
                    if (object == null) break block4;
                    Class<?> clazz = object.getClass();
                    Class[] classArray = new Class[]{ClassLoader.class};
                    Method method = clazz.getDeclaredMethod("shutdownClusterService", classArray);
                    Object[] objectArray = new Object[]{classLoader};
                    method.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    this.processException(exception);
                    Object var8_9 = null;
                    this.jmxBridge.shutdown(classLoader);
                }
            }
            Object var8_8 = null;
            this.jmxBridge.shutdown(classLoader);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.jmxBridge.shutdown(classLoader);
            throw throwable;
        }
    }

    public void addCacheConfiguration(ClassLoader classLoader) throws CoherenceException {
        try {
            Object object = this.getWLSCacheFactoryBuilder(classLoader);
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class[] classArray = new Class[]{ClassLoader.class};
                Method method = clazz.getDeclaredMethod("addCacheConfiguration", classArray);
                Object[] objectArray = new Object[]{classLoader};
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
    }

    public void releaseCacheConfiguration(ClassLoader classLoader) throws CoherenceException {
        try {
            Object object = this.getWLSCacheFactoryBuilder(classLoader);
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class[] classArray = new Class[]{ClassLoader.class};
                Method method = clazz.getDeclaredMethod("releaseAll", classArray);
                Object[] objectArray = new Object[]{classLoader};
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
    }

    public Object ensureCache(String string, ClassLoader classLoader) throws CoherenceException {
        try {
            Object object = this.getWLSCacheFactoryBuilder(classLoader);
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class[] classArray = new Class[]{String.class, ClassLoader.class};
                Method method = clazz.getMethod("ensureCache", classArray);
                Object[] objectArray = new Object[]{string, classLoader};
                Object object2 = method.invoke(object, objectArray);
                if (DebugLogger.isDebugEnabled()) {
                    DebugLogger.debug("CoherenceClusterManager: got cache " + object2 + "using classloader " + classLoader);
                }
                return object2;
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
        return null;
    }

    public Object ensureService(String string, ClassLoader classLoader) throws CoherenceException {
        try {
            Object object = this.getWLSCacheFactoryBuilder(classLoader);
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class[] classArray = new Class[]{String.class};
                Method method = clazz.getMethod("ensureService", classArray);
                Object[] objectArray = new Object[]{string};
                return method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
        return null;
    }

    public void registerApplicationRuntimeMBean(ClassLoader classLoader, ApplicationRuntimeMBean applicationRuntimeMBean) throws ManagementException {
        this.jmxBridge.registerApplicationRuntimeMBean(classLoader, applicationRuntimeMBean);
    }

    public void unRegisterApplicationRuntimeMBean(ClassLoader classLoader, ApplicationRuntimeMBean applicationRuntimeMBean) throws ManagementException {
        this.jmxBridge.unRegisterApplicationRuntimeMBean(classLoader, applicationRuntimeMBean);
    }

    public void registerWebAppComponentRuntimeMBean(ClassLoader classLoader, WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray) throws ManagementException {
        this.jmxBridge.registerWebAppComponentRuntimeMBean(classLoader, webAppComponentRuntimeMBeanArray);
    }

    public void unRegisterWebAppComponentRuntimeMBean(ClassLoader classLoader, WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray) throws ManagementException {
        this.jmxBridge.unRegisterWebAppComponentRuntimeMBean(classLoader, webAppComponentRuntimeMBeanArray);
    }

    public void registerEJBComponentRuntimeMBean(ClassLoader classLoader, EJBComponentRuntimeMBean eJBComponentRuntimeMBean) throws ManagementException {
        this.jmxBridge.registerEJBComponentRuntimeMBean(classLoader, eJBComponentRuntimeMBean);
    }

    public void unRegisterEJBComponentRuntimeMBean(ClassLoader classLoader, EJBComponentRuntimeMBean eJBComponentRuntimeMBean) throws ManagementException {
        this.jmxBridge.unRegisterEJBComponentRuntimeMBean(classLoader, eJBComponentRuntimeMBean);
    }

    public CoherenceClusterSystemResourceMBean[] getAllLocalCoherenceClusterSystemResourceMBeans() {
        ArrayList<CoherenceClusterSystemResourceMBean> arrayList = new ArrayList<CoherenceClusterSystemResourceMBean>();
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        String string2 = null;
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getCluster() != null) {
            string2 = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName();
        }
        CoherenceClusterSystemResourceMBean[] coherenceClusterSystemResourceMBeanArray = domainMBean.getCoherenceClusterSystemResources();
        for (int i = 0; i < coherenceClusterSystemResourceMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = coherenceClusterSystemResourceMBeanArray[i].getTargets();
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                if (!targetMBeanArray[j].getName().equals(string) && (string2 == null || !targetMBeanArray[j].getName().equals(string2))) continue;
                arrayList.add(coherenceClusterSystemResourceMBeanArray[i]);
            }
        }
        return arrayList.toArray(new CoherenceClusterSystemResourceMBean[0]);
    }

    private Object getWLSCoherenceConfigurator(ClassLoader classLoader) throws CoherenceException {
        try {
            Class<?> clazz = Class.forName("weblogic.coherence.service.internal.WLSCoherenceConfigurator", true, classLoader);
            Class[] classArray = new Class[]{Object.class};
            Method method = clazz.getDeclaredMethod("getInstance", classArray);
            Object[] objectArray = new Object[]{this.jmxBridge};
            return method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            this.processException(exception);
            return null;
        }
    }

    private Object getWLSCacheFactoryBuilder(ClassLoader classLoader) throws CoherenceException {
        try {
            Object object = this.getWLSCoherenceConfigurator(classLoader);
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod("getCacheFactoryBuilder", null);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            this.processException(exception);
            return null;
        }
    }

    private void processException(Throwable throwable) throws CoherenceException {
        if (throwable instanceof CoherenceException) {
            throw (CoherenceException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getCause();
        }
        CoherenceException coherenceException = new CoherenceException(throwable.getMessage());
        coherenceException.initCause(throwable);
        throw coherenceException;
    }

    private CoherenceClusterSystemResourceMBean lookupCoherenceClusterSystemResourceMBean(String string) {
        if (string == null) {
            return null;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return domainMBean.lookupCoherenceClusterSystemResource(string);
    }

    private String getCoherenceClusterConfigDir(CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean) throws IOException {
        String string = coherenceClusterSystemResourceMBean.getCustomClusterConfigurationFileName();
        String string2 = DomainDir.getConfigDir();
        String string3 = coherenceClusterSystemResourceMBean.getDescriptorFileName();
        File file = new File(string2 + File.separator + string3);
        File file2 = file.getParentFile();
        return file2.getCanonicalPath();
    }

    private String getLoggingDestination() {
        ServerMBean serverMBean = CoherenceClusterManager.getServerMBean();
        if (serverMBean.getLog().isLog4jLoggingEnabled()) {
            return "log4j";
        }
        return "jdk";
    }

    public static ServerMBean getServerMBean() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return serverMBean;
    }

    private static class SingletonMaker {
        private static final CoherenceClusterManager singleton = new CoherenceClusterManager();

        private SingletonMaker() {
        }
    }
}

