/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider.coherence.application;

import weblogic.application.AppDeploymentExtension;
import weblogic.application.ApplicationContextInternal;
import weblogic.cacheprovider.CacheProviderLogger;
import weblogic.cacheprovider.coherence.CoherenceClusterManager;
import weblogic.j2ee.descriptor.wl.CoherenceClusterRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;
import weblogic.utils.classloaders.GenericClassLoader;

public class CoherenceAppDeploymentExtension
implements AppDeploymentExtension {
    public String getName() {
        return this.getClass().getName();
    }

    public void init(ApplicationContextInternal applicationContextInternal) {
    }

    public void prepare(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
        if (!applicationContextInternal.isEar()) {
            return;
        }
        try {
            GenericClassLoader genericClassLoader = applicationContextInternal.getAppClassLoader();
            CoherenceClusterRefBean coherenceClusterRefBean = this.getCoherenceClusterRefBean(applicationContextInternal);
            CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
            boolean bl = coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader);
            String string = null;
            if (coherenceClusterRefBean != null) {
                string = coherenceClusterRefBean.getCoherenceClusterName();
                if (!bl) {
                    throw new DeploymentException("Missing Coherence jars or WebLogic Coherence Integration jars");
                }
            }
            if (bl) {
                coherenceClusterManager.registerApplicationRuntimeMBean((ClassLoader)genericClassLoader, applicationContextInternal.getRuntime());
                coherenceClusterManager.configureClusterService((ClassLoader)genericClassLoader, string);
                coherenceClusterManager.addCacheConfiguration((ClassLoader)genericClassLoader);
            }
        }
        catch (DeploymentException deploymentException) {
            throw deploymentException;
        }
        catch (Exception exception) {
            throw new DeploymentException(exception.getMessage(), exception);
        }
    }

    public void activate(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
    }

    public void deactivate(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
    }

    public void unprepare(ApplicationContextInternal applicationContextInternal) throws DeploymentException {
        if (!applicationContextInternal.isEar()) {
            return;
        }
        try {
            GenericClassLoader genericClassLoader = applicationContextInternal.getAppClassLoader();
            CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
            if (coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader)) {
                coherenceClusterManager.releaseCacheConfiguration((ClassLoader)genericClassLoader);
                coherenceClusterManager.shutdownClusterService((ClassLoader)genericClassLoader);
                coherenceClusterManager.unRegisterApplicationRuntimeMBean((ClassLoader)genericClassLoader, applicationContextInternal.getRuntime());
            }
        }
        catch (Exception exception) {
            CacheProviderLogger.logFailedToUnprepare((String)applicationContextInternal.getApplicationId(), (Exception)exception);
        }
    }

    private CoherenceClusterRefBean getCoherenceClusterRefBean(ApplicationContextInternal applicationContextInternal) {
        CoherenceClusterRefBean coherenceClusterRefBean = null;
        WeblogicApplicationBean weblogicApplicationBean = applicationContextInternal.getWLApplicationDD();
        if (weblogicApplicationBean != null) {
            coherenceClusterRefBean = weblogicApplicationBean.getCoherenceClusterRef();
        }
        return coherenceClusterRefBean;
    }
}

