/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider.coherence.jndi;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.cacheprovider.coherence.CoherenceClusterManager;
import weblogic.jndi.OpaqueReference;

public class CoherenceOpaqueReference
implements OpaqueReference {
    private String objectName;
    private ClassLoader loader;
    private String type;
    private volatile Object referent;

    public CoherenceOpaqueReference(String string, String string2, ClassLoader classLoader) {
        this.objectName = string;
        this.type = string2;
        this.loader = classLoader;
    }

    public Object getReferent(Name name, Context context) throws NamingException {
        if (this.referent == null) {
            try {
                CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
                if (this.type.equals("com.tangosol.net.NamedCache")) {
                    this.referent = coherenceClusterManager.ensureCache(this.objectName, this.loader);
                } else if (this.type.equals("com.tangosol.net.Service")) {
                    this.referent = coherenceClusterManager.ensureService(this.objectName, this.loader);
                }
            }
            catch (Exception exception) {
                NameNotFoundException nameNotFoundException = new NameNotFoundException(exception.getMessage());
                nameNotFoundException.initCause(exception);
                throw nameNotFoundException;
            }
        }
        if (this.referent != null) {
            return this.referent;
        }
        throw new NameNotFoundException(this + " not bound");
    }

    public String toString() {
        return this.type + "::" + this.objectName;
    }
}

