/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cacheprovider.coherence.management;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import weblogic.cacheprovider.coherence.management.CoherenceClusterRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;

public class CoherenceJMXBridge {
    private Map<ClassLoader, RuntimeMBeanEntry> runtimeMBeanByLoader = new ConcurrentHashMap<ClassLoader, RuntimeMBeanEntry>();
    private ObjectName sysScopedClusterObjectName;
    private MBeanServer sysScopedMBeanServer;
    private boolean isSystemScoped;

    public void registerApplicationRuntimeMBean(ClassLoader classLoader, ApplicationRuntimeMBean applicationRuntimeMBean) throws ManagementException {
        this.runtimeMBeanByLoader.put(classLoader, new RuntimeMBeanEntry(applicationRuntimeMBean));
        if (this.isSystemScoped) {
            applicationRuntimeMBean.setCoherenceClusterRuntime(new CoherenceClusterRuntimeMBeanImpl(this.sysScopedClusterObjectName, this.sysScopedMBeanServer, applicationRuntimeMBean));
        }
    }

    public void unRegisterApplicationRuntimeMBean(ClassLoader classLoader, ApplicationRuntimeMBean applicationRuntimeMBean) throws ManagementException {
        this.runtimeMBeanByLoader.remove(classLoader);
    }

    public void registerWebAppComponentRuntimeMBean(ClassLoader classLoader, WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray) throws ManagementException {
        this.runtimeMBeanByLoader.put(classLoader, new RuntimeMBeanEntry(webAppComponentRuntimeMBeanArray));
        if (this.isSystemScoped) {
            for (WebAppComponentRuntimeMBean webAppComponentRuntimeMBean : webAppComponentRuntimeMBeanArray) {
                webAppComponentRuntimeMBean.setCoherenceClusterRuntime(new CoherenceClusterRuntimeMBeanImpl(this.sysScopedClusterObjectName, this.sysScopedMBeanServer, webAppComponentRuntimeMBean));
            }
        }
    }

    public void unRegisterWebAppComponentRuntimeMBean(ClassLoader classLoader, WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray) throws ManagementException {
        this.runtimeMBeanByLoader.remove(classLoader);
    }

    public void registerEJBComponentRuntimeMBean(ClassLoader classLoader, EJBComponentRuntimeMBean eJBComponentRuntimeMBean) throws ManagementException {
        this.runtimeMBeanByLoader.put(classLoader, new RuntimeMBeanEntry(eJBComponentRuntimeMBean));
        if (this.isSystemScoped) {
            eJBComponentRuntimeMBean.setCoherenceClusterRuntime(new CoherenceClusterRuntimeMBeanImpl(this.sysScopedClusterObjectName, this.sysScopedMBeanServer, eJBComponentRuntimeMBean));
        }
    }

    public void unRegisterEJBComponentRuntimeMBean(ClassLoader classLoader, EJBComponentRuntimeMBean eJBComponentRuntimeMBean) throws ManagementException {
        this.runtimeMBeanByLoader.remove(classLoader);
    }

    public void clusterStarted(ClassLoader classLoader, ObjectName objectName, MBeanServer mBeanServer) throws ManagementException {
        RuntimeMBeanEntry runtimeMBeanEntry = this.runtimeMBeanByLoader.get(classLoader);
        if (runtimeMBeanEntry != null) {
            runtimeMBeanEntry.setCoherenceClusterRuntimeMBean(objectName, mBeanServer);
        } else {
            this.sysScopedClusterObjectName = objectName;
            this.sysScopedMBeanServer = mBeanServer;
            this.isSystemScoped = true;
        }
    }

    public void shutdown(ClassLoader classLoader) {
        Iterator<ClassLoader> iterator = this.runtimeMBeanByLoader.keySet().iterator();
        while (iterator.hasNext()) {
            ClassLoader classLoader2 = iterator.next();
            if (!this.isChildOfLoader(classLoader, classLoader2)) continue;
            iterator.remove();
        }
    }

    private boolean isChildOfLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == classLoader) {
            return true;
        }
        for (ClassLoader classLoader3 = classLoader2.getParent(); classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader) continue;
            return true;
        }
        return false;
    }

    private class RuntimeMBeanEntry {
        ApplicationRuntimeMBean appRuntimeMBean;
        WebAppComponentRuntimeMBean[] webAppRuntimeMBeans;
        EJBComponentRuntimeMBean ejbRuntimeMBean;

        private RuntimeMBeanEntry(ApplicationRuntimeMBean applicationRuntimeMBean) {
            this.appRuntimeMBean = applicationRuntimeMBean;
        }

        private RuntimeMBeanEntry(WebAppComponentRuntimeMBean[] webAppComponentRuntimeMBeanArray) {
            this.webAppRuntimeMBeans = webAppComponentRuntimeMBeanArray;
        }

        private RuntimeMBeanEntry(EJBComponentRuntimeMBean eJBComponentRuntimeMBean) {
            this.ejbRuntimeMBean = eJBComponentRuntimeMBean;
        }

        private void setCoherenceClusterRuntimeMBean(ObjectName objectName, MBeanServer mBeanServer) throws ManagementException {
            CoherenceClusterRuntimeMBeanImpl coherenceClusterRuntimeMBeanImpl = null;
            if (this.appRuntimeMBean != null) {
                coherenceClusterRuntimeMBeanImpl = new CoherenceClusterRuntimeMBeanImpl(objectName, mBeanServer, this.appRuntimeMBean);
                this.appRuntimeMBean.setCoherenceClusterRuntime(coherenceClusterRuntimeMBeanImpl);
            } else if (this.webAppRuntimeMBeans != null) {
                for (WebAppComponentRuntimeMBean webAppComponentRuntimeMBean : this.webAppRuntimeMBeans) {
                    coherenceClusterRuntimeMBeanImpl = new CoherenceClusterRuntimeMBeanImpl(objectName, mBeanServer, webAppComponentRuntimeMBean);
                    webAppComponentRuntimeMBean.setCoherenceClusterRuntime(coherenceClusterRuntimeMBeanImpl);
                }
            } else if (this.ejbRuntimeMBean != null) {
                coherenceClusterRuntimeMBeanImpl = new CoherenceClusterRuntimeMBeanImpl(objectName, mBeanServer, this.ejbRuntimeMBean);
                this.ejbRuntimeMBean.setCoherenceClusterRuntime(coherenceClusterRuntimeMBeanImpl);
            }
        }
    }
}

