/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterService;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class AlternateLivelinessChecker {
    private static final boolean DEBUG = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String SECRET_STRING = "&ServerName=" + ManagementService.getRuntimeAccess(kernelId).getServer().getName() + "&PingOnly=true";
    private static final byte[] SERVER_HASH_VALUE = ClusterService.getClusterService().getSecureHash();
    private HashMap unreachableMap = new HashMap();
    private Set underExecutionSet = new HashSet();

    public static AlternateLivelinessChecker getInstance() {
        return Factory.THE_ONE;
    }

    public synchronized void reachable(HostID hostID) {
        this.unreachableMap.remove(hostID);
    }

    private int getRetryCount() {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        return clusterMBean.getHTTPPingRetryCount();
    }

    private int getCurrentCount(HostID hostID) {
        Integer n = (Integer)this.unreachableMap.get(hostID);
        return n != null ? n : 0;
    }

    private int getActiveServerRetryCount() {
        Iterator iterator = this.unreachableMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (this.getCurrentCount((HostID)iterator.next()) >= this.getRetryCount()) continue;
            ++n;
        }
        return n;
    }

    synchronized void addToUnreachableSet(HostID hostID) {
        int n = this.getCurrentCount(hostID);
        this.unreachableMap.put(hostID, ++n);
        this.underExecutionSet.remove(hostID);
    }

    synchronized void addToReachableSet(HostID hostID) {
        this.unreachableMap.put(hostID, 0);
        this.underExecutionSet.remove(hostID);
    }

    public synchronized boolean isUnreachable(long l, HostID hostID) {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean.getMaxServerCountForHttpPing() <= 0) {
            return true;
        }
        if (this.getCurrentCount(hostID) >= this.getRetryCount()) {
            return true;
        }
        if (this.underExecutionSet.contains(hostID)) {
            return false;
        }
        if (this.getActiveServerRetryCount() >= clusterMBean.getMaxServerCountForHttpPing()) {
            return true;
        }
        if (this.unreachableMap.get(hostID) == null) {
            this.unreachableMap.put(hostID, 0);
        }
        HTTPPingRequest hTTPPingRequest = new HTTPPingRequest(l, hostID);
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)hTTPPingRequest));
        this.underExecutionSet.add(hostID);
        return false;
    }

    private static void debug(String string) {
        Debug.say((String)("[AlternateLivenessChecker] " + string));
    }

    private final class HTTPPingRequest
    extends WorkAdapter {
        private static final boolean DEBUG = false;
        private HttpURLConnection con;
        private DataInputStream in;
        private final String request;
        private final HostID memberID;
        private final long lastSeqNum;

        HTTPPingRequest(long l, HostID hostID) {
            this.lastSeqNum = l;
            this.request = this.getHeader();
            this.memberID = hostID;
        }

        private void connect() throws ConnectException, IOException {
            URL uRL = this.getServerURL();
            this.con = (HttpURLConnection)uRL.openConnection();
            this.con.setRequestMethod("POST");
            this.con.setDoInput(true);
            this.con.setDoOutput(true);
            OutputStream outputStream = this.con.getOutputStream();
            this.con.connect();
            outputStream.write(SERVER_HASH_VALUE);
            outputStream.flush();
            outputStream.close();
            this.in = new DataInputStream(this.con.getInputStream());
        }

        private URL getServerURL() throws MalformedURLException {
            return ClusterHelper.fabricateHTTPURL(this.request, this.memberID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block22: {
                block19: {
                    this.connect();
                    if (this.con.getResponseCode() == 200) {
                        AlternateLivelinessChecker.this.addToReachableSet(this.memberID);
                        break block19;
                    }
                    AlternateLivelinessChecker.this.addToUnreachableSet(this.memberID);
                }
                Object var3_1 = null;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.con != null) {
                    this.con.disconnect();
                }
                break block22;
                {
                    catch (ConnectException connectException) {
                        AlternateLivelinessChecker.this.addToUnreachableSet(this.memberID);
                        Object var3_2 = null;
                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (this.con != null) {
                            this.con.disconnect();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {
                        AlternateLivelinessChecker.this.addToUnreachableSet(this.memberID);
                        Object var3_3 = null;
                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        if (this.con != null) {
                            this.con.disconnect();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                    throw throwable;
                }
            }
        }

        private String getHeader() {
            return "/bea_wls_cluster_internal/psquare/p2?senderNum=0&lastSeqNum=" + this.lastSeqNum + "&PeerInfo=" + ClusterHelper.STRINGFIED_PEERINFO + SECRET_STRING;
        }
    }

    private static final class Factory {
        static final AlternateLivelinessChecker THE_ONE = new AlternateLivelinessChecker();

        private Factory() {
        }
    }
}

