/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import weblogic.cluster.AnnouncementMessage;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MemberServices;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.cluster.ServiceOffer;
import weblogic.cluster.ServiceRetract;
import weblogic.cluster.StateDumpMessage;
import weblogic.cluster.TreeManager;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class AnnouncementManager
implements RecoverListener,
MulticastSessionIDConstants {
    private static AnnouncementManager theAnnouncementManager = null;
    private MemberServices localServices;
    private MulticastSession announcementSender;
    private boolean blocked = true;
    private ArrayList blockedItems = new ArrayList();
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static AnnouncementManager theOne() {
        return theAnnouncementManager;
    }

    static void initialize(long l) {
        theAnnouncementManager = new AnnouncementManager(l);
    }

    private AnnouncementManager(long l) {
        TreeManager.initialize(l);
        this.localServices = new MemberServices((HostID)LocalServerIdentity.getIdentity());
        this.announcementSender = ClusterService.getClusterService().createMulticastSession(2, this, -1, true);
    }

    synchronized void unblockAnnouncements() {
        this.blocked = false;
        this.announcementSender = ClusterService.getClusterService().createMulticastSession(2, this, -1, true);
        if (!this.blockedItems.isEmpty()) {
            this.sendAnnouncement(this.blockedItems);
            this.blockedItems = null;
        }
    }

    synchronized void blockAnnouncements() {
        this.blocked = true;
        this.announcementSender = null;
        this.blockedItems = new ArrayList();
    }

    synchronized void shutdown() {
        this.localServices.retractAllOffers(true);
        this.blocked = true;
    }

    public synchronized void announce(ServiceRetract serviceRetract, ServiceOffer serviceOffer) {
        if (serviceRetract != null) {
            this.localServices.processRetract(serviceRetract, true);
        }
        if (serviceOffer != null) {
            this.localServices.processOffer(serviceOffer, true);
        }
        if (this.blocked) {
            if (serviceRetract != null) {
                int n = serviceRetract.id();
                ServiceOffer serviceOffer2 = null;
                for (Object e : this.blockedItems) {
                    ServiceOffer serviceOffer3;
                    if (!(e instanceof ServiceOffer) || (serviceOffer3 = (ServiceOffer)e).id() != n) continue;
                    serviceOffer2 = serviceOffer3;
                    break;
                }
                if (serviceOffer2 != null && !serviceRetract.ignoreRetract()) {
                    this.blockedItems.remove(serviceOffer2);
                } else {
                    this.blockedItems.add(serviceRetract);
                }
            }
            if (serviceOffer != null) {
                this.blockedItems.add(serviceOffer);
            }
        } else {
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            if (serviceRetract != null) {
                arrayList.add(serviceRetract);
            }
            if (serviceOffer != null) {
                arrayList.add(serviceOffer);
            }
            this.sendAnnouncement(arrayList);
        }
    }

    private void sendAnnouncement(ArrayList arrayList) {
        AnnouncementMessage announcementMessage = new AnnouncementMessage(arrayList);
        if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
            ClusterAnnouncementsDebugLogger.debug("Sending " + announcementMessage);
        }
        try {
            this.announcementSender.send(announcementMessage);
        }
        catch (IOException iOException) {
            ClusterLogger.logMulticastSendError((IOException)iOException);
        }
    }

    void receiveAnnouncement(HostID hostID, AnnouncementMessage announcementMessage) {
        final HostID hostID2 = hostID;
        final AnnouncementMessage announcementMessage2 = announcementMessage;
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                    ClusterAnnouncementsDebugLogger.debug("Received " + announcementMessage2 + " from " + hostID2);
                }
                RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate(hostID2);
                try {
                    remoteMemberInfo.processAnnouncement(announcementMessage2.items);
                    Object var3_2 = null;
                    MemberManager.theOne().done(remoteMemberInfo);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    MemberManager.theOne().done(remoteMemberInfo);
                    throw throwable;
                }
                return null;
            }
        });
    }

    public synchronized GroupMessage createRecoverMessage() {
        StateDumpMessage stateDumpMessage = new StateDumpMessage(this.localServices.getAllOffers(), 2, this.getCurrentSeqNum());
        if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
            ClusterAnnouncementsDebugLogger.debug("Sending " + stateDumpMessage);
        }
        return stateDumpMessage;
    }

    long getCurrentSeqNum() {
        return MulticastManager.theOne().findSender(2).getCurrentSeqNum();
    }

    public synchronized MemberServices getLocalOffers() {
        return this.localServices;
    }

    void receiveStateDump(HostID hostID, StateDumpMessage stateDumpMessage) {
        final StateDumpMessage stateDumpMessage2 = stateDumpMessage;
        final HostID hostID2 = hostID;
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                    ClusterAnnouncementsDebugLogger.debug("Received " + stateDumpMessage2 + " from " + hostID2);
                }
                RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate(hostID2);
                try {
                    remoteMemberInfo.processStateDump(stateDumpMessage2.offers, stateDumpMessage2.senderNum, stateDumpMessage2.currentSeqNum);
                    Object var3_2 = null;
                    MemberManager.theOne().done(remoteMemberInfo);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    MemberManager.theOne().done(remoteMemberInfo);
                    throw throwable;
                }
                return null;
            }
        });
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

