/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import weblogic.cluster.AttributesMessage;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.rmi.spi.HostID;

final class AttributeManager
implements RecoverListener,
MulticastSessionIDConstants {
    private static AttributeManager theAttributeManager = null;
    private final MemberAttributes localAttributes;
    private MulticastSession attributeSender = ClusterService.getClusterService().createMulticastSession(1, this, 1, false);

    static AttributeManager theOne() {
        return theAttributeManager;
    }

    static void initialize(MemberAttributes memberAttributes) throws IOException {
        theAttributeManager = new AttributeManager(memberAttributes);
    }

    private AttributeManager(MemberAttributes memberAttributes) {
        this.localAttributes = memberAttributes;
    }

    void sendAttributes() throws IOException {
        if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
            ClusterAnnouncementsDebugLogger.debug("Sending local attributes " + this.localAttributes);
        }
        this.attributeSender.send(new AttributesMessage(this.localAttributes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveAttributes(HostID hostID, AttributesMessage attributesMessage) {
        if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
            ClusterAnnouncementsDebugLogger.debug("Received " + attributesMessage + " from " + hostID);
        }
        RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate(hostID);
        try {
            remoteMemberInfo.processAttributes(attributesMessage.attributes);
            Object var5_4 = null;
            MemberManager.theOne().done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MemberManager.theOne().done(remoteMemberInfo);
            throw throwable;
        }
    }

    public GroupMessage createRecoverMessage() {
        return new AttributesMessage(this.localAttributes);
    }

    MemberAttributes getLocalAttributes() {
        return this.localAttributes;
    }
}

