/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NamingException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.ServiceOffer;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.jndi.WLContext;
import weblogic.rmi.cluster.ClusterableRemoteObject;
import weblogic.rmi.spi.HostID;

public final class BasicServiceOffer
implements ServiceOffer,
Externalizable {
    private static final long serialVersionUID = 2651365883729651106L;
    private int id;
    private String name;
    private Object service;
    private HostID memID;
    private long creationTime;
    private int oldID = -1;
    private String appId;

    public BasicServiceOffer(int n, String string, String string2, Object object) {
        this.id = n;
        this.name = string;
        this.appId = string2;
        this.service = object;
        this.creationTime = System.currentTimeMillis();
    }

    public BasicServiceOffer(int n, String string, String string2, Object object, int n2) {
        this(n, string, string2, object);
        this.oldID = n2;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String appID() {
        return this.appId;
    }

    public String serviceName() {
        return " from " + this.memID.toString();
    }

    public boolean isClusterable() {
        return this.service instanceof ClusterableRemoteObject;
    }

    public long approximateAge() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public int getOldID() {
        return this.oldID;
    }

    public void setServer(HostID hostID) {
        this.memID = hostID;
    }

    public HostID getServerID() {
        return this.memID;
    }

    public String toString() {
        return this.name + "@" + this.appId + ":" + (this.service != null ? this.service.getClass().getName() : "Subcontext") + " (from " + this.memID + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(Context context) throws NamingException {
        if (this.service != null) {
            try {
                if (this.appId != null) {
                    ApplicationVersionUtils.setBindApplicationId(this.appId);
                }
                context.bind(this.name, this.service);
                Object var3_2 = null;
                if (this.appId == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.appId == null) throw throwable;
                ApplicationVersionUtils.unsetBindApplicationId();
                throw throwable;
            }
            ApplicationVersionUtils.unsetBindApplicationId();
            return;
        }
        context.createSubcontext(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void retract(Context context) throws NamingException {
        if (this.service != null) {
            try {
                if (this.appId != null) {
                    ApplicationVersionUtils.setBindApplicationId(this.appId);
                }
                ((WLContext)context).unbind(this.name, this.service);
                Object var3_2 = null;
                if (this.appId == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.appId == null) throw throwable;
                ApplicationVersionUtils.unsetBindApplicationId();
                throw throwable;
            }
            ApplicationVersionUtils.unsetBindApplicationId();
            return;
        }
        try {
            context.destroySubcontext(this.name);
            return;
        }
        catch (ContextNotEmptyException contextNotEmptyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Context context) throws NamingException {
        if (this.service != null) {
            try {
                if (this.appId != null) {
                    ApplicationVersionUtils.setBindApplicationId(this.appId);
                }
                ((WLContext)context).rebind(this.name, this.service);
                Object var3_2 = null;
                if (this.appId == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.appId == null) throw throwable;
                ApplicationVersionUtils.unsetBindApplicationId();
                throw throwable;
            }
            ApplicationVersionUtils.unsetBindApplicationId();
            return;
        }
        try {
            context.destroySubcontext(this.name);
            return;
        }
        catch (ContextNotEmptyException contextNotEmptyException) {
            // empty catch block
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeInt(this.id);
        wLObjectOutput.writeString(this.name);
        wLObjectOutput.writeObjectWL(this.service);
        wLObjectOutput.writeLong(System.currentTimeMillis() - this.creationTime);
        wLObjectOutput.writeInt(this.oldID);
        wLObjectOutput.writeString(this.appId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
        this.id = wLObjectInput.readInt();
        this.name = wLObjectInput.readString();
        this.service = wLObjectInput.readObjectWL();
        this.creationTime = System.currentTimeMillis() - wLObjectInput.readLong();
        this.oldID = wLObjectInput.readInt();
        try {
            this.appId = wLObjectInput.readString();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public BasicServiceOffer() {
    }
}

