/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.management.configuration.ClusterMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.utils.net.InetAddressHelper;

public class ClusterAddressHelper
implements ClusterMembersChangeListener {
    private static boolean debug = false;
    private static final ClusterAddressHelper singleton = new ClusterAddressHelper();
    private boolean isInitialized = false;
    private boolean needsDynamicConstruction = false;
    private boolean needToAppendPort = false;
    private int membersInList = 3;
    private List members = Collections.synchronizedList(new ArrayList());
    private String clusterAddressConfigured;

    public static ClusterAddressHelper getInstance() {
        return singleton;
    }

    public static String getClusterAddressURL(ServerChannel serverChannel) {
        return serverChannel.getProtocolPrefix() + "://" + ClusterAddressHelper.getInstance().getClusterAddress(serverChannel);
    }

    private ClusterAddressHelper() {
    }

    final void initialize(ClusterMBean clusterMBean) {
        this.clusterAddressConfigured = clusterMBean.getClusterAddress();
        this.membersInList = clusterMBean.getNumberOfServersInClusterAddress();
        if (this.clusterAddressConfigured == null || this.clusterAddressConfigured.length() == 0) {
            this.needsDynamicConstruction = true;
        } else {
            this.verifyClusterAddress(this.clusterAddressConfigured);
        }
        if (this.needsDynamicConstruction) {
            this.debugSay(" adding " + this + " as ClusterMembersChangeListener.");
            ClusterService.getClusterService().addClusterMembersListener(this);
            this.members.add(LocalServerIdentity.getIdentity());
        }
        this.isInitialized = true;
        this.debugSay(" Initialized ClusterAddressHelper with clusterAddressConfigured to= " + this.clusterAddressConfigured + " : membersInList= " + this.membersInList);
    }

    private final String getClusterAddress(ServerChannel serverChannel) {
        if (!this.isInitialized) {
            return serverChannel.getPublicAddress() + ':' + serverChannel.getPublicPort();
        }
        if (this.needsDynamicConstruction) {
            return this.constructClusterAddress(serverChannel);
        }
        if (!this.needToAppendPort) {
            return this.clusterAddressConfigured;
        }
        return this.clusterAddressConfigured + ':' + serverChannel.getPublicPort();
    }

    public final void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        ClusterMemberInfo clusterMemberInfo = clusterMembersChangeEvent.getClusterMemberInfo();
        int n = clusterMembersChangeEvent.getAction();
        ServerIdentity serverIdentity = clusterMemberInfo.identity();
        if (n == 1) {
            this.debugSay(" Removing a member to the list : " + serverIdentity);
            this.members.remove(serverIdentity);
            this.dumpList(" +++ clusterMembersChanged() : ", this.members);
        } else if (n == 0) {
            this.debugSay(" Adding a member to the list : " + serverIdentity);
            this.members.add(serverIdentity);
            this.dumpList(" +++ clusterMembersChanged() : ", this.members);
        }
    }

    private final String constructClusterAddress(ServerChannel serverChannel) {
        List list = this.selectServerListRandomly();
        List list2 = this.getHostPortInfo(list, serverChannel);
        HostPortInfo[] hostPortInfoArray = new HostPortInfo[list2.size()];
        hostPortInfoArray = list2.toArray(hostPortInfoArray);
        boolean bl = this.hasMixedPorts(hostPortInfoArray);
        UnsyncStringBuffer unsyncStringBuffer = new UnsyncStringBuffer();
        for (int i = 0; i < hostPortInfoArray.length; ++i) {
            if (i != 0) {
                unsyncStringBuffer.append(",");
            }
            if (bl) {
                unsyncStringBuffer.append(hostPortInfoArray[i].getHostPort());
                continue;
            }
            unsyncStringBuffer.append(hostPortInfoArray[i].getHost());
        }
        if (!bl) {
            unsyncStringBuffer.append(":").append(serverChannel.getPublicPort()).toString();
        }
        this.debugSay(" +++ constructClusterAddress() : " + unsyncStringBuffer.toString());
        return unsyncStringBuffer.toString();
    }

    private boolean needToAppendPort() {
        return this.needToAppendPort;
    }

    private boolean hasMixedPorts(HostPortInfo[] hostPortInfoArray) {
        if (hostPortInfoArray.length == 1) {
            this.needToAppendPort = true;
            return false;
        }
        int n = hostPortInfoArray[0].getPort();
        for (int i = 1; i < hostPortInfoArray.length; ++i) {
            if (n == hostPortInfoArray[i].getPort()) continue;
            this.needToAppendPort = false;
            return true;
        }
        this.needToAppendPort = true;
        return false;
    }

    private List getHostPortInfo(List list, ServerChannel serverChannel) {
        ArrayList<HostPortInfo> arrayList = new ArrayList<HostPortInfo>();
        for (ServerIdentity serverIdentity : list) {
            int n;
            String string;
            if (serverIdentity.isLocal()) {
                this.debugSay(" +++ got local server channel : " + serverChannel);
                string = serverChannel.getPublicAddress();
                n = serverChannel.getPublicPort();
            } else {
                ServerChannel serverChannel2 = ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)serverChannel.getProtocol(), (String)serverChannel.getChannelName());
                this.debugSay(" +++ got server channel : " + serverChannel2);
                if (serverChannel2 == null) {
                    serverChannel2 = ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)serverChannel.getProtocol());
                    this.debugSay(" +++ got server channel[1] : " + serverChannel2);
                    if (serverChannel2 == null) {
                        serverChannel2 = ServerChannelManager.findServerChannel((HostID)serverIdentity);
                        this.debugSay(" +++ got server channel[2] : " + serverChannel2);
                        if (serverChannel2 == null) {
                            throw new AssertionError((Object)("ServerChannel for id : " + serverIdentity + " is null"));
                        }
                    }
                }
                string = serverChannel2.getPublicAddress();
                n = serverChannel2.getPublicPort();
            }
            this.debugSay(" +++ eachHost, eachPort : " + string + "," + n + " : for id --- " + serverIdentity);
            arrayList.add(this.getHostPortInfo(string, n, n != -1));
        }
        this.dumpList(" +++ getHostPortInfo() : ", arrayList);
        return arrayList;
    }

    private List selectServerListRandomly() {
        this.debugSay(" Selecting Server List Randomly...");
        ServerIdentity[] serverIdentityArray = new ServerIdentity[this.members.size()];
        serverIdentityArray = this.members.toArray(serverIdentityArray);
        Random random = new Random(System.currentTimeMillis());
        int n = random.nextInt(serverIdentityArray.length);
        int n2 = serverIdentityArray.length <= this.membersInList ? serverIdentityArray.length : this.membersInList;
        ArrayList<ServerIdentity> arrayList = new ArrayList<ServerIdentity>();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            if (n3 >= serverIdentityArray.length) {
                n3 = 0;
            }
            arrayList.add(serverIdentityArray[n3]);
            ++n3;
        }
        this.dumpList(" +++ selectServerListRandomly() :", arrayList);
        return arrayList;
    }

    private void verifyClusterAddress(String string) {
        if (string != null && string.length() != 0) {
            int n = 0;
            String[] stringArray = StringUtils.splitCompletely((String)string, (String)",", (boolean)false);
            if (stringArray.length > 1) {
                try {
                    List list = this.constructHostPortInfos(string);
                    boolean bl = this.allHasPorts(list);
                    boolean bl2 = this.allHasNoPorts(list);
                    if (!bl && !bl2) {
                        this.needsDynamicConstruction = true;
                        return;
                    }
                    if (bl) {
                        this.needToAppendPort = false;
                        return;
                    }
                    if (bl2) {
                        this.needToAppendPort = true;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ClusterLogger.logInvalidConfiguredClusterAddress((String)string);
                    this.needsDynamicConstruction = true;
                }
            } else {
                try {
                    InetAddress.getByName(string);
                    this.needToAppendPort = true;
                }
                catch (UnknownHostException unknownHostException) {
                    if (stringArray.length > 1) {
                        ClusterLogger.logCannotResolveClusterAddressWarning((String)(string + ": Unknown host: " + stringArray[n]));
                    } else {
                        ClusterLogger.logCannotResolveClusterAddressWarning((String)string);
                    }
                    this.needsDynamicConstruction = true;
                }
            }
        }
    }

    List constructHostPortInfos(String string) {
        ArrayList<HostPortInfo> arrayList = new ArrayList<HostPortInfo>();
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",", (boolean)false);
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                HostPortInfo hostPortInfo = this.constructHostPortInfo(stringArray[i]);
                arrayList.add(hostPortInfo);
            }
        } else {
            throw new AssertionError((Object)"ClusterAddress has dns name when it isalready verified as non dns name");
        }
        return arrayList;
    }

    private HostPortInfo constructHostPortInfo(String string) {
        this.debugSay(" nodeAddressPort is " + string);
        int n = 58;
        int n2 = -1;
        int n3 = -1;
        String string2 = string;
        boolean bl = false;
        int n4 = string.indexOf(91);
        int n5 = string.indexOf(93);
        if (n4 > -1 && n5 > 0) {
            n3 = string.indexOf(n, n5);
            bl = true;
        } else if (n4 == -1 && n5 == -1) {
            if (InetAddressHelper.isIPV6Address((String)string)) {
                n3 = string.lastIndexOf(n);
                bl = true;
            } else {
                n3 = string.indexOf(n);
            }
        }
        this.debugSay(" portIndex is " + n3);
        if (n3 > -1) {
            string2 = string.substring(0, n3);
            if (n3 + 1 != string.length()) {
                String string3 = string.substring(n3 + 1);
                try {
                    n2 = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    NumberFormatException numberFormatException2 = numberFormatException;
                    if (bl) {
                        numberFormatException2 = new NumberFormatException("IPV6 addresses have to be specified in [a:b:c:d:e:f:g]:port format");
                    }
                    throw numberFormatException2;
                }
            }
        }
        return this.getHostPortInfo(string2, n2, n2 > 0);
    }

    private HostPortInfo getHostPortInfo(final String string, final int n, final boolean bl) {
        return new HostPortInfo(){

            public String getHost() {
                return string;
            }

            public int getPort() {
                return n;
            }

            public boolean hasPort() {
                return bl;
            }

            public String getHostPort() {
                return string + ":" + n;
            }

            public String toString() {
                return "HostPortInfo(" + this.getHost() + "," + this.getPort() + "," + this.hasPort() + ")";
            }
        };
    }

    private boolean allHasPorts(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((HostPortInfo)iterator.next()).hasPort()) continue;
            return false;
        }
        return true;
    }

    private boolean allHasNoPorts(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!((HostPortInfo)iterator.next()).hasPort()) continue;
            return false;
        }
        return true;
    }

    private void debugSay(String string) {
        if (debug) {
            Debug.say((String)(" --- " + string));
        }
    }

    private void dumpList(String string, List list) {
        if (!debug) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        Iterator iterator = list.iterator();
        stringBuffer.append("List [");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString()).append(",");
        }
        String string2 = stringBuffer.toString().substring(0, stringBuffer.toString().lastIndexOf(44));
        string2 = string2 + "]";
        this.debugSay(string2);
    }

    private void dumpList(String string, Object[] objectArray) {
        if (!debug) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(" [");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        stringBuffer.append("]");
        this.debugSay(stringBuffer.toString());
    }

    private static interface HostPortInfo {
        public String getHost();

        public int getPort();

        public boolean hasPort();

        public String getHostPort();
    }
}

