/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.util.HashMap;
import java.util.Set;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.MemberManager;

public class ClusterDropoutListener
implements ClusterMembersChangeListener {
    private static final boolean DEBUG = true;
    private static HashMap dropouts = new HashMap();
    private static ClusterDropoutListener theClusterDropoutListener;

    public static ClusterDropoutListener theOne() {
        return theClusterDropoutListener;
    }

    static void initialize() {
        if (theClusterDropoutListener != null) {
            return;
        }
        theClusterDropoutListener = new ClusterDropoutListener();
    }

    private ClusterDropoutListener() {
        MemberManager.theOne().addClusterMembersListener(this);
    }

    public HashMap getDropoutCounts() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(dropouts.size());
        Set set = dropouts.keySet();
        if (set == null) {
            return hashMap;
        }
        for (String string : set) {
            DropoutCounter dropoutCounter = (DropoutCounter)dropouts.get(string);
            hashMap.put(string, new Integer(dropoutCounter.getCount()));
        }
        return hashMap;
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        if (clusterMembersChangeEvent.getAction() == 1) {
            DropoutCounter dropoutCounter = (DropoutCounter)dropouts.get(clusterMembersChangeEvent.getClusterMemberInfo().serverName());
            if (dropoutCounter == null) {
                dropoutCounter = new DropoutCounter();
            }
            dropoutCounter.increment();
            dropouts.put(clusterMembersChangeEvent.getClusterMemberInfo().serverName(), dropoutCounter);
        }
    }

    private void debug(Object object) {
        System.out.println("<ClusterDropoutListener> " + object.toString());
    }

    private static class DropoutCounter {
        private int dropouts = 0;

        private DropoutCounter() {
        }

        public void increment() {
            ++this.dropouts;
        }

        public int getCount() {
            return this.dropouts;
        }

        public String toString() {
            return "Number of dropouts: " + this.dropouts;
        }
    }
}

