/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.common.internal.PeerInfo;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.rmi.spi.HostID;
import weblogic.server.channels.AddressUtils;
import weblogic.servlet.security.Utils;
import weblogic.utils.StringUtils;
import weblogic.utils.io.DataIO;
import weblogic.utils.net.SocketResetException;

public final class ClusterHelper {
    public static final String STRINGFIED_PEERINFO = PeerInfo.getPeerInfo().getMajor() + "," + PeerInfo.getPeerInfo().getMinor() + "," + PeerInfo.getPeerInfo().getServicePack();

    public static URL fabricateHTTPURL(String string, HostID hostID) throws MalformedURLException {
        String string2 = URLManager.findAdministrationURL((ServerIdentity)hostID);
        if (string2 == null) {
            throw new MalformedURLException("Could not construct URL for: " + hostID);
        }
        string2 = URLManager.normalizeToHttpProtocol(string2);
        return new URL(new URL(string2), string);
    }

    public static String getMachineName() {
        return AddressUtils.getLocalHost().getHostName();
    }

    public static PeerInfo getPeerInfo(String string) {
        return PeerInfo.getPeerInfo((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void logStateDumpRequestRejection(HttpURLConnection httpURLConnection, IOException iOException, String string) {
        String string2;
        block16: {
            string2 = null;
            if (httpURLConnection != null) {
                int n = httpURLConnection.getContentLength();
                InputStream inputStream = httpURLConnection.getErrorStream();
                if (n > 0 && inputStream != null) {
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    byte[] byArray = new byte[n];
                    DataIO.readFully((InputStream)dataInputStream, (byte[])byArray);
                    string2 = StringUtils.getString((byte[])byArray);
                    Object var10_8 = null;
                    try {
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {}
                    break block16;
                    {
                        catch (IOException iOException3) {
                            Object var10_9 = null;
                            try {
                                if (dataInputStream != null) {
                                    dataInputStream.close();
                                }
                                break block16;
                            }
                            catch (IOException iOException4) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        try {
                            if (dataInputStream != null) {
                                dataInputStream.close();
                            }
                        }
                        catch (IOException iOException5) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (string2 != null) {
            ClusterLogger.logFailedWhileReceivingStateDumpWithMessage((String)string, (Exception)iOException, string2, (String)ClusterService.getClusterService().getLocalServerDetails());
        } else if (ClusterAnnouncementsDebugLogger.isDebugEnabled() || !SocketResetException.isResetException((IOException)iOException)) {
            ClusterLogger.logFailedWhileReceivingStateDump((String)string, (Exception)iOException);
        }
    }

    public static String encodeXSS(String string) {
        return Utils.encodeXSS(string);
    }
}

