/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.cluster.ClusterDropoutListener;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.replication.LocalSecondarySelector;
import weblogic.cluster.replication.MANReplicationManager;
import weblogic.cluster.replication.RemoteClusterSecondarySelector;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.ServerMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ClusterRuntimeMBean;
import weblogic.management.runtime.JobSchedulerRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerMigrationRuntimeMBean;
import weblogic.management.runtime.UnicastMessagingRuntimeMBean;
import weblogic.rmi.spi.HostID;
import weblogic.scheduler.JobSchedulerRuntimeMBeanImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;

public final class ClusterRuntime
extends RuntimeMBeanDelegate
implements ClusterRuntimeMBean {
    private static final long serialVersionUID = 7321104020611342137L;
    private static int invocationCounter = 0;
    private String clusterType;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static void initialize(String string) {
        try {
            ClusterRuntime clusterRuntime = new ClusterRuntime(string);
            clusterRuntime.clusterType = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getClusterType();
        }
        catch (ManagementException managementException) {
            ClusterLogger.logErrorCreatingClusterRuntime((Throwable)managementException);
        }
    }

    public ClusterRuntime() throws ManagementException {
        throw new AssertionError("for JMX compliance only");
    }

    private ClusterRuntime(String string) throws ManagementException {
        super(string);
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setClusterRuntime(this);
    }

    public int getAliveServerCount() {
        return ClusterService.getServices().getRemoteMembers().size() + 1;
    }

    public long getResendRequestsCount() {
        return MulticastManager.theOne().getResendRequestsCount();
    }

    public long getFragmentsSentCount() {
        return MulticastManager.theOne().getFragmentsSentCount();
    }

    public long getFragmentsReceivedCount() {
        return MulticastManager.theOne().getFragmentsReceivedCount();
    }

    public long getMulticastMessagesLostCount() {
        return MulticastManager.theOne().getMulticastMessagesLostCount();
    }

    public String[] getServerNames() {
        Collection collection = ClusterService.getServices().getRemoteMembers();
        String[] stringArray = new String[collection.size() + 1];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            stringArray[n++] = clusterMemberInfo.serverName();
        }
        stringArray[n] = ClusterService.getServices().getLocalMember().serverName();
        return stringArray;
    }

    public String[] getSecondaryDistributionNames() {
        if (this.clusterType.equals("man")) {
            return MANReplicationManager.theOne().getSecondaryDistributionNames();
        }
        return ReplicationManager.theOne().getSecondaryDistributionNames();
    }

    public String[] getDetailedSecondariesDistribution() {
        return this.getSecondaryDistributionNames();
    }

    public long getPrimaryCount() {
        if (this.clusterType.equals("man")) {
            return MANReplicationManager.theOne().getPrimaryCount();
        }
        return ReplicationManager.theOne().getPrimaryCount();
    }

    public long getSecondaryCount() {
        return ReplicationManager.theOne().getSecondaryCount();
    }

    public long getForeignFragmentsDroppedCount() {
        return MulticastManager.theOne().getForeignFragmentsDroppedCount();
    }

    public String getCurrentSecondaryServer() {
        if (this.clusterType.equals("man")) {
            HostID hostID = RemoteClusterSecondarySelector.getSecondarySelector().getSecondarySrvr();
            return hostID != null ? hostID.toString() : "";
        }
        HostID hostID = LocalSecondarySelector.getSecondarySelector().getSecondarySrvr();
        return hostID != null ? hostID.toString() : "";
    }

    public String getSecondaryServerDetails() {
        return this.getCurrentSecondaryServer();
    }

    public HashMap getUnreliableServers() {
        return ClusterDropoutListener.theOne().getDropoutCounts();
    }

    public HealthState getHealthState() {
        return new HealthState(0);
    }

    public MachineMBean getCurrentMachine() {
        return MigratableServerService.theOne().getCurrentMachine();
    }

    public ServerMigrationRuntimeMBean getServerMigrationRuntime() {
        return ServerMigrationRuntimeMBeanImpl.getInstance();
    }

    public JobSchedulerRuntimeMBean getJobSchedulerRuntime() {
        return JobSchedulerRuntimeMBeanImpl.getInstance();
    }

    public UnicastMessagingRuntimeMBean getUnicastMessaging() {
        try {
            Class<?> clazz = Class.forName("weblogic.cluster.messaging.internal.server.UnicastMessagingRuntimeMBeanImpl");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            method.setAccessible(true);
            return (UnicastMessagingRuntimeMBean)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getActiveSingletonServices() {
        return SingletonServicesManager.getInstance().getActiveServiceNames();
    }
}

