/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.AttributeManager;
import weblogic.cluster.ClusterAddressHelper;
import weblogic.cluster.ClusterDiagnosticImageSource;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterRuntime;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.ClusterTextTextFormatter;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.UpgradeUtils;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.DatabaseLeasingBasis;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.LeaseManagerFactory;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceNotFoundException;
import weblogic.health.HealthFeedback;
import weblogic.health.HealthMonitorService;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rjvm.JVMID;
import weblogic.rmi.cluster.ServerInfoManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.HMAC;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.ByteArrayDiffChecker;
import weblogic.utils.StringUtils;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class ClusterService
extends ActivatedService
implements ClusterServices,
BeanUpdateListener {
    private static ClusterService singleton = null;
    static final String MULTICAST_QUEUE = "ClusterMessaging";
    static WorkManager MULTICAST_WORKMANAGER;
    private static final AuthenticatedSubject kernelId;
    private static final SecurityHolder securityHolder;
    private static final ClusterTextTextFormatter FORMATTER;
    private ImageSource clusterDiagnosticImageSource = new ClusterDiagnosticImageSource();
    private boolean isMemberDeathDetectorEnabled = false;
    private LeasingBasis defaultLeasingBasis;
    private ClusterMBean clusterMBean;
    private static boolean isServerInCluster;
    private String clusterName;
    private boolean useOneWayRMI;

    public ClusterService() {
        singleton = this;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess != null) {
            runtimeAccess.getServer().addBeanUpdateListener(this);
        }
    }

    public static ClusterService getClusterService() {
        return singleton;
    }

    public boolean startService() throws ServiceFailureException {
        Object object;
        String string;
        boolean bl = false;
        ClusterService.securityHolder.init();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.clusterMBean = serverMBean.getCluster();
        String string2 = string = serverMBean.getMachine() == null ? ClusterHelper.getMachineName() : serverMBean.getMachine().getName();
        if (this.clusterMBean != null) {
            int n;
            Object object2;
            this.useOneWayRMI = this.clusterMBean.isOneWayRmiForReplicationEnabled();
            this.isMemberDeathDetectorEnabled = this.clusterMBean.isMemberDeathDetectorEnabled() && this.verifyMemberDeathDetectorConfiguration();
            ServerInfoManager.theOne().addServer(serverMBean.getName(), (HostID)LocalServerIdentity.getIdentity(), serverMBean.getClusterWeight());
            this.clusterName = this.clusterMBean.getName();
            object = this.clusterMBean.getMulticastAddress();
            if (object == null || ((String)object).equals("")) {
                ClusterLogger.logMissingClusterMulticastAddressError((String)this.clusterName);
                throw new ServiceFailureException("configuration problem - missing multicast address for cluster: " + this.clusterName);
            }
            String string3 = this.clusterMBean.getClusterAddress();
            if (string3 != null) {
                int n2;
                object2 = StringUtils.splitCompletely((String)string3, (String)",", (boolean)false);
                n = new String(":").charAt(0);
                try {
                    if (((String[])object2).length > 1) {
                        for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                            String string4 = StringUtils.upto((String)object2[n2], (char)n);
                            InetAddress.getByName(string4);
                        }
                    } else {
                        InetAddress.getByName(string3);
                    }
                    JVMID.localID().setClusterAddress(string3);
                }
                catch (UnknownHostException unknownHostException) {
                    if (((String[])object2).length > 1) {
                        ClusterLogger.logCannotResolveClusterAddressWarning((String)(string3 + ": Unknown host: " + object2[n2]));
                    }
                    ClusterLogger.logCannotResolveClusterAddressWarning((String)string3);
                }
            }
            try {
                FORMATTER.startingClusterService();
                MemberAttributes memberAttributes = new MemberAttributes(serverMBean.getListenAddress(), string, VersionInfo.theOne().getReleaseVersion(), System.currentTimeMillis(), serverMBean.getClusterWeight(), serverMBean.getReplicationGroup(), serverMBean.getPreferredSecondaryGroup(), this.clusterName, serverMBean.isAutoMigrationEnabled(), this.clusterMBean.getReplicationChannel(), PeerInfo.getPeerInfo());
                MulticastManager.initialize(this.clusterMBean.getMulticastAddress(), ManagementService.getRuntimeAccess(kernelId).getServer().getInterfaceAddress(), this.clusterMBean.getMulticastPort(), (byte)this.clusterMBean.getMulticastTTL(), this.clusterMBean.getMulticastSendDelay());
                AnnouncementManager.initialize(this.clusterMBean.getServiceAgeThresholdSeconds());
                MemberManager.initialize(memberAttributes.joinTime(), this.clusterMBean.getIdlePeriodsUntilTimeout());
                UpgradeUtils.getInstance();
                ClusterAddressHelper.getInstance().initialize(this.clusterMBean);
                AttributeManager.initialize(memberAttributes);
                ClusterRuntime.initialize(this.clusterName);
                MULTICAST_WORKMANAGER = WorkManagerFactory.getInstance().findOrCreate(MULTICAST_QUEUE, -1, 1);
                isServerInCluster = true;
                object2 = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getClusterRuntime();
                HealthMonitorService.register("Cluster", (HealthFeedback)object2, true);
                ReplicationManager.theOne();
                n = this.clusterMBean.getHealthCheckIntervalMillis();
                int n3 = this.clusterMBean.getHealthCheckPeriodsUntilFencing();
                boolean bl2 = this.isLeasingBasisNeeded(this.clusterMBean);
                if (bl2 && this.clusterMBean.getMigrationBasis().equals("database") && this.clusterMBean.getDataSourceForAutomaticMigration() == null) {
                    ClusterExtensionLogger.logDataSourceForDatabaseLeasingNotSet((String)this.clusterMBean.getName());
                    throw new ServiceFailureException("Cluster " + this.clusterMBean.getName() + " uses database as the migration basis but no data source for " + " migration has been configured");
                }
                if (this.clusterMBean.getMigrationBasis().equals("database") && (bl2 || this.clusterMBean.getDataSourceForAutomaticMigration() != null)) {
                    this.defaultLeasingBasis = DatabaseLeasingBasis.createBasis(serverMBean, this.clusterMBean.getDataSourceForAutomaticMigration(), n3 * n / 1000, this.clusterMBean.getAutoMigrationTableName());
                } else if (this.clusterMBean.getMigrationBasis().equals("consensus")) {
                    this.defaultLeasingBasis = AbstractConsensusService.getInstance().createConsensusBasis(n, n3 * n);
                } else if (this.clusterMBean.getDataSourceForJobScheduler() != null) {
                    this.defaultLeasingBasis = DatabaseLeasingBasis.createBasis(serverMBean, this.clusterMBean.getDataSourceForJobScheduler(), n3 * n / 1000, this.clusterMBean.getAutoMigrationTableName());
                }
                if (this.defaultLeasingBasis != null) {
                    LeaseManagerFactory.singleton().initialize(this.defaultLeasingBasis, n, n3 * n, this.clusterMBean.getFencingGracePeriodMillis());
                }
                bl = true;
            }
            catch (IOException iOException) {
                ClusterLogger.logFailedToJoinClusterError((String)this.clusterName, (String)this.clusterMBean.getMulticastAddress(), (Exception)iOException);
                throw new ServiceFailureException((Throwable)iOException);
            }
        }
        object = ImageManager.getInstance();
        ((ImageManager)object).registerImageSource("Cluster", this.clusterDiagnosticImageSource);
        return bl;
    }

    private boolean verifyMemberDeathDetectorConfiguration() {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        boolean bl = true;
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            if (serverMBean.getMachine() != null) continue;
            bl = false;
            ClusterExtensionLogger.logServerWithNoMachineConfigured((String)serverMBean.getName());
        }
        return bl;
    }

    public void stopService() throws ServiceFailureException {
        this.haltService();
    }

    public synchronized void haltService() throws ServiceFailureException {
        if (this.clusterMBean != null && isServerInCluster) {
            ClusterLogger.logLeavingCluster((String)this.clusterMBean.getName());
            MulticastManager.theOne().forceSuspend();
            MulticastManager.theOne().stopListening();
            MemberManager.theOne().shutdown();
            AnnouncementManager.theOne().shutdown();
            HealthMonitorService.unregister("Cluster");
            ImageManager imageManager = ImageManager.getInstance();
            try {
                imageManager.unregisterImageSource("Cluster");
            }
            catch (ImageSourceNotFoundException imageSourceNotFoundException) {
                // empty catch block
            }
        }
    }

    public static ClusterServices getServices() {
        if (isServerInCluster) {
            return ClusterService.getClusterService();
        }
        return null;
    }

    MulticastSession createMulticastSession(int n, RecoverListener recoverListener, int n2, boolean bl) {
        return MulticastManager.theOne().createSender(n, recoverListener, n2, bl);
    }

    public MulticastSession createMulticastSession(RecoverListener recoverListener, int n, boolean bl) {
        return this.createMulticastSession(-1, recoverListener, n, bl);
    }

    public MulticastSession createMulticastSession(RecoverListener recoverListener, int n) {
        return this.createMulticastSession(-1, recoverListener, n, false);
    }

    public MulticastSession createMulticastSession(RecoverListener recoverListener, int n, boolean bl, boolean bl2) {
        return MulticastManager.theOne().createSender(-1, recoverListener, n, bl, bl2);
    }

    public ClusterMemberInfo getLocalMember() {
        return isServerInCluster ? AttributeManager.theOne().getLocalAttributes() : null;
    }

    public Collection getRemoteMembers() {
        return MemberManager.theOne().getRemoteMembers();
    }

    public Collection getAllRemoteMembers() {
        return MemberManager.theOne().getRemoteMembers(true);
    }

    public Collection getClusterMasterMembers() {
        return Collections.EMPTY_SET;
    }

    public void addClusterMembersListener(ClusterMembersChangeListener clusterMembersChangeListener) {
        MemberManager.theOne().addClusterMembersListener(clusterMembersChangeListener);
    }

    public void removeClusterMembersListener(ClusterMembersChangeListener clusterMembersChangeListener) {
        MemberManager.theOne().removeClusterMembersListener(clusterMembersChangeListener);
    }

    public void addHeartbeatMessage(GroupMessage groupMessage) {
        MulticastManager.theOne().addItem(groupMessage);
    }

    public void removeHeartbeatMessage(GroupMessage groupMessage) {
        MulticastManager.theOne().removeItem(groupMessage);
    }

    public int getHeartbeatTimeoutMillis() {
        return this.clusterMBean.getIdlePeriodsUntilTimeout() * 10000;
    }

    public void resendLocalAttributes() {
        try {
            AttributeManager.theOne().sendAttributes();
        }
        catch (IOException iOException) {
            ClusterLogger.logFailureUpdatingServerInTheCluster((String)ManagementService.getRuntimeAccess(kernelId).getServer().getName(), (IOException)iOException);
        }
    }

    public LeaseManager getDefaultLeaseManager(String string) {
        return LeaseManagerFactory.singleton().getLeaseManager(string);
    }

    public LeasingBasis getDefaultLeasingBasis() {
        return this.defaultLeasingBasis;
    }

    private boolean isLeasingBasisNeeded(ClusterMBean clusterMBean) {
        return ClusterService.isMigratableCluster(clusterMBean) || ClusterService.isAutoServiceMigrationEnabled(clusterMBean);
    }

    private static boolean isMigratableCluster(ClusterMBean clusterMBean) {
        if (clusterMBean == null) {
            return false;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].isAutoMigrationEnabled()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAutoServiceMigrationEnabled(ClusterMBean clusterMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBean.getMigratableTargets();
        for (int i = 0; migratableTargetMBeanArray != null && i < migratableTargetMBeanArray.length; ++i) {
            if ("manual".equals(migratableTargetMBeanArray[i].getMigrationPolicy())) continue;
            return true;
        }
        DomainMBean domainMBean = (DomainMBean)clusterMBean.getParent();
        SingletonServiceMBean[] singletonServiceMBeanArray = domainMBean.getSingletonServices();
        for (int i = 0; singletonServiceMBeanArray != null && i < singletonServiceMBeanArray.length; ++i) {
            if (singletonServiceMBeanArray[i].getCluster() == null || !singletonServiceMBeanArray[i].getCluster().getName().equals(clusterMBean.getName())) continue;
            return true;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; serverMBeanArray != null && i < serverMBeanArray.length; ++i) {
            JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBeanArray[i].getJTAMigratableTarget();
            if (jTAMigratableTargetMBean == null || !jTAMigratableTargetMBean.getMigrationPolicy().equals("failure-recovery")) continue;
            return true;
        }
        return false;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        boolean bl = false;
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            bl = true;
        }
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            String string = propertyUpdateArray[i].getPropertyName();
            if (string.equals("Cluster")) {
                throw new BeanUpdateRejectedException("Cannot update '" + string + "' while the server is running");
            }
            if (!string.equals("Machine")) continue;
            if (bl) {
                ClusterExtensionLogger.logUpdatingNonDynamicPropertyOnAdminServer((String)string);
                continue;
            }
            throw new BeanUpdateRejectedException("Cannot update '" + string + "' while the server is running");
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    byte[] getSecureHash() {
        return ClusterService.securityHolder.getSecretHash();
    }

    boolean checkRequest(String string, byte[] byArray) {
        ByteArrayDiffChecker byteArrayDiffChecker = new ByteArrayDiffChecker();
        byte[] byArray2 = ClusterService.securityHolder.getEncryptionService().encryptString(string);
        byte[] byArray3 = HMAC.digest((byte[])byArray2, (byte[])ClusterService.securityHolder.getSecret(), (byte[])ClusterService.securityHolder.getSalt());
        return byteArrayDiffChecker.diffByteArrays(byArray, byArray3) == null;
    }

    boolean multicastDataEncryptionEnabled() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getMulticastDataEncryption();
    }

    public boolean isReplicationTimeoutEnabled() {
        return this.clusterMBean.isReplicationTimeoutEnabled();
    }

    String getLocalServerDetails() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        String string2 = ManagementService.getRuntimeAccess(kernelId).getDomainName();
        return "Server '" + string + "', cluster '" + this.clusterName + "', domain '" + string2 + "',  with attributes " + "multicastDataEncryptionEnabled '" + this.multicastDataEncryptionEnabled() + "' and Admin channel available '" + ChannelHelper.isLocalAdminChannelEnabled() + "'";
    }

    boolean isUnicastMessagingModeEnabled() {
        return this.clusterMBean.getClusterMessagingMode().equals("unicast");
    }

    public boolean useOneWayRMI() {
        return this.useOneWayRMI;
    }

    public boolean isMemberDeathDetectorEnabled() {
        return this.isMemberDeathDetectorEnabled;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        securityHolder = new SecurityHolder();
        FORMATTER = new ClusterTextTextFormatter();
        isServerInCluster = false;
    }

    private static final class SecurityHolder {
        private boolean initialized = false;
        private EncryptionService es = null;
        private byte[] SALT = null;
        private byte[] SECRET = null;
        private byte[] SECRET_HASH = null;

        private SecurityHolder() {
        }

        private EncryptionService getEncryptionService() {
            return this.es;
        }

        private byte[] getSecretHash() {
            return this.SECRET_HASH;
        }

        private byte[] getSecret() {
            return this.SECRET;
        }

        private byte[] getSalt() {
            return this.SALT;
        }

        private synchronized void init() {
            if (this.initialized) {
                return;
            }
            this.es = SerializedSystemIni.getEncryptionService();
            this.SALT = SerializedSystemIni.getSalt();
            this.SECRET = SerializedSystemIni.getEncryptedSecretKey();
            this.SECRET_HASH = HMAC.digest((byte[])this.es.encryptString(ManagementService.getRuntimeAccess(kernelId).getServer().getName()), (byte[])this.SECRET, (byte[])this.SALT);
            this.initialized = true;
        }
    }
}

