/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.security.AccessController;
import weblogic.cluster.ClusterTextTextFormatter;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.platform.OperatingSystem;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class ClusterValidator {
    private static final ClusterTextTextFormatter fmt = new ClusterTextTextFormatter();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static void validateMulticastAddress(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Multicast addresses must be of format: ddd.ddd.ddd.ddd where d is a digit.");
        }
        if (nArray[0] < 224 || nArray[0] > 239 || nArray[1] < 0 || nArray[1] > 255 || nArray[2] < 0 || nArray[2] > 255 || nArray[3] < 0 || nArray[3] > 255) {
            throw new IllegalArgumentException("Illegal value for MulticastAddress, the address must be in the range 224.0.0.0 - 239.255.255.255.");
        }
    }

    public static void validateAutoMigration(boolean bl) {
        if (!bl) {
            return;
        }
        String string = OperatingSystem.getOSName();
        if (string.equals("linux") || string.equals("solaris") || string.equals("sun") || string.equals("solarisx86") || string.equals("hp-ux") || string.equals("windows") || string.equals("aix")) {
            return;
        }
        throw new IllegalArgumentException("Automatic Migration is only supported on Linux, Solaris and HP-UX operating systems.");
    }

    public static void canSetCluster(ServerMBean serverMBean, ClusterMBean clusterMBean) {
        if (ManagementService.isRuntimeAccessInitialized()) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (runtimeAccess != null && !runtimeAccess.isAdminServer()) {
                return;
            }
            DomainMBean domainMBean = runtimeAccess.getDomain();
            ServerMBean serverMBean2 = domainMBean.lookupServer(serverMBean.getName());
            if (serverMBean2 == null) {
                return;
            }
            MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
            for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                String string;
                if (!migratableTargetMBeanArray[i].getParent().getType().equals("Domain")) continue;
                String string2 = serverMBean.getName() + " (migratable)";
                if (migratableTargetMBeanArray[i].getName().equals(string2)) continue;
                boolean bl = migratableTargetMBeanArray[i].getUserPreferredServer().getName().equals(serverMBean.getName());
                String string3 = serverMBean2.getCluster() == null ? null : serverMBean2.getCluster().getName();
                String string4 = string = clusterMBean == null ? null : clusterMBean.getName();
                if (!bl || string3 == null && string == null) continue;
                if (string3 != null && string != null && !string3.equals(string)) {
                    throw new IllegalArgumentException(fmt.getCannotChangeClusterWhileServerReferredToInMigratableTarget(string3, serverMBean.getName()));
                }
                if (string3 == null || string != null) continue;
                throw new IllegalArgumentException(fmt.getCannotChangeClusterWhileServerReferredToInMigratableTarget(string3, serverMBean.getName()));
            }
        }
    }
}

