/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import weblogic.security.HMAC;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.ByteArrayDiffChecker;

final class EncryptionHelper {
    private static final EncryptionService es = SerializedSystemIni.getEncryptionService();
    private static final byte[] SALT = SerializedSystemIni.getSalt();
    private static final byte[] SECRET = SerializedSystemIni.getEncryptedSecretKey();
    private static final ByteArrayDiffChecker DIFF_CHECKER = new ByteArrayDiffChecker();

    EncryptionHelper() {
    }

    static byte[] encrypt(byte[] byArray) {
        return es.encryptBytes(byArray);
    }

    static byte[] decrypt(byte[] byArray, AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return es.decryptBytes(byArray);
    }

    static byte[] sign(byte[] byArray) {
        return HMAC.digest((byte[])byArray, (byte[])SECRET, (byte[])SALT);
    }

    static boolean verify(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = HMAC.digest((byte[])byArray, (byte[])SECRET, (byte[])SALT);
        return DIFF_CHECKER.diffByteArrays(byArray2, byArray3) == null;
    }
}

